/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.raycaster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import tauri.dev.jsg.raycaster.util.Box;
import tauri.dev.jsg.raycaster.util.DHDVertex;
import tauri.dev.jsg.raycaster.util.Ray;
import tauri.dev.vector.Vector2f;
import tauri.dev.vector.Vector3f;

public abstract class Raycaster {
    protected abstract List<Vector3f> getVertices();

    protected abstract int getRayGroupCount();

    protected abstract Vector3f getTranslation(World var1, BlockPos var2);

    protected abstract void check(World var1, BlockPos var2, EntityPlayer var3, int var4, int var5);

    protected abstract boolean brbCheck(List<Ray> var1, Vec3d var2, EntityPlayer var3, BlockPos var4, EnumHand var5);

    public boolean onActivated(World world, BlockPos pos, EntityPlayer player, float rotation, EnumHand hand) {
        Ray lastRay = null;
        Ray firstRay = null;
        ArrayList<Ray> brbRayList = new ArrayList<Ray>();
        Vec3d lookVec = player.func_70040_Z();
        boolean found = false;
        for (int x = 1; x <= this.getVertices().size() / this.getRayGroupCount(); ++x) {
            int i;
            Ray currentRay = x == this.getVertices().size() / this.getRayGroupCount() ? firstRay : new Ray(this.getTransposedRay(x, rotation, world, pos, player));
            if (lastRay == null) {
                lastRay = firstRay = new Ray(this.getTransposedRay(0, rotation, world, pos, player));
            }
            ArrayList<Ray> transverseRays = new ArrayList<Ray>();
            for (i = 0; i < this.getRayGroupCount(); ++i) {
                Ray r = new Ray(currentRay.getVert(i), lastRay.getVert(i));
                transverseRays.add(r);
                if (i != 2) continue;
                brbRayList.add(r);
            }
            for (i = 0; i < this.getRayGroupCount() - 1; ++i) {
                Box box = new Box(currentRay, lastRay, (Ray)transverseRays.get(i), (Ray)transverseRays.get(i + 1), i);
                if (!box.checkForPointInBox(new Vector2f((float)lookVec.field_72450_a, (float)lookVec.field_72449_c))) continue;
                this.check(world, pos, player, x, i);
                found = true;
                break;
            }
            if (found) break;
            lastRay = currentRay;
        }
        return found |= this.brbCheck(brbRayList, lookVec, player, pos, hand);
    }

    private Vector2f getTransposed(Vector3f v, float rotation, World world, BlockPos pos, EntityPlayer player) {
        DHDVertex current = new DHDVertex(v.x, v.y, v.z);
        return current.rotate(rotation).localToGlobal(pos, this.getTranslation(world, pos)).calculateDiffrence(player).getViewport(player.func_70040_Z());
    }

    private List<Vector2f> getTransposedRay(int rayIndex, float rotation, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<Vector2f> out = new ArrayList<Vector2f>();
        for (int i = 0; i < this.getRayGroupCount(); ++i) {
            out.add(this.getTransposed(this.getVertices().get(rayIndex * this.getRayGroupCount() + i), rotation, world, pos, player));
        }
        return out;
    }
}

