/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.power.zpm;

import java.util.ArrayList;
import java.util.List;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;
import tauri.dev.jsg.power.zpm.ZPMEnergyStorage;

public class ZPMHubEnergyStorage
extends ZPMEnergyStorage {
    private final List<IEnergyStorageZPM> storages = new ArrayList<IEnergyStorageZPM>();

    public ZPMHubEnergyStorage(int maxTransfer) {
        super(0L, maxTransfer);
    }

    public void clearStorages() {
        this.storages.clear();
    }

    public void addStorage(IEnergyStorageZPM storage) {
        this.storages.add(storage);
    }

    @Override
    public long getEnergyStored() {
        long energyStored = this.energy;
        for (IEnergyStorageZPM storage : this.storages) {
            energyStored += storage.getEnergyStored();
        }
        return energyStored;
    }

    @Override
    public long getMaxEnergyStored() {
        long maxEnergyStored = this.capacity;
        for (IEnergyStorageZPM storage : this.storages) {
            maxEnergyStored += storage.getMaxEnergyStored();
        }
        return maxEnergyStored;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int toReceive = maxReceive;
        toReceive -= super.receiveEnergy(maxReceive, simulate);
        for (IEnergyStorageZPM storage : this.storages) {
            if (toReceive == 0) {
                return maxReceive;
            }
            toReceive -= storage.receiveEnergy(toReceive, simulate);
        }
        return maxReceive - toReceive;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int toExtract = maxExtract;
        for (IEnergyStorageZPM storage : this.storages) {
            if (toExtract == 0) {
                return maxExtract;
            }
            toExtract -= storage.extractEnergy(toExtract, simulate);
        }
        toExtract -= super.extractEnergy(toExtract, simulate);
        return maxExtract - toExtract;
    }

    public void setEnergyStoredInternally(long energy) {
        this.energy = energy;
    }

    public long getEnergyStoredInternally() {
        return this.energy;
    }

    public long getMaxEnergyStoredInternally() {
        return this.capacity;
    }
}

