/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.power.zpm;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;

public class ZPMEnergyStorage
implements IEnergyStorageZPM,
INBTSerializable<NBTTagCompound> {
    protected long energy;
    protected long capacity;
    public int maxReceive;
    public int maxExtract;

    public ZPMEnergyStorage(long capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public ZPMEnergyStorage(long capacity, int maxReceive, int maxExtract, int energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, (long)energy));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74772_a("energy", this.energy);
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_74764_b("energy")) {
                this.energy = nbt.func_74762_e("energy");
            }
            if (nbt.func_74764_b("longEnergy")) {
                this.energy = nbt.func_74763_f("longEnergy");
            }
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = (int)Math.min(this.capacity - this.energy, (long)Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        if (energyReceived > 0) {
            this.onEnergyChanged();
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        if (!simulate) {
            this.energy -= (long)maxExtract;
            if (this.energy < 0L) {
                this.energy = 0L;
            }
            this.onEnergyChanged();
        } else if ((long)maxExtract > this.energy) {
            maxExtract = (int)this.energy;
        }
        return maxExtract;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    public void setEnergyStored(long energyStored) {
        this.energy = Math.min(energyStored, this.capacity);
        this.onEnergyChanged();
    }

    protected void onEnergyChanged() {
    }
}

