/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.power.stargate;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import tauri.dev.jsg.config.JSGConfig;

public class StargateItemEnergyStorage
implements IEnergyStorage {
    protected final ItemStack stack;
    protected final int maxEnergyStored;

    public StargateItemEnergyStorage(ItemStack stack, int maxEnergyStored) {
        this.stack = stack;
        this.maxEnergyStored = maxEnergyStored;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energyStored, Math.min(JSGConfig.Stargate.power.stargateMaxEnergyTransfer, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.getEnergyStored()) {
            maxExtract = this.getEnergyStored();
        }
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - maxExtract);
        }
        return maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.getOrCreateCompound(this.stack).func_74768_a("energy", energy);
    }

    public int getEnergyStored() {
        return this.getOrCreateCompound(this.stack).func_74762_e("energy");
    }

    public int getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    protected NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

