/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet.transportrings;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.renderer.effect.DestinyFTL;
import tauri.dev.jsg.renderer.effect.RingsWhiteFadeOut;

public class StartPlayerFadeOutToClient
implements IMessage {
    private int type;

    public StartPlayerFadeOutToClient() {
    }

    public StartPlayerFadeOutToClient(EnumFadeOutEffectType type) {
        this.type = type.id;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
    }

    public static class StartPlayerFadeOutToClientHandler
    implements IMessageHandler<StartPlayerFadeOutToClient, IMessage> {
        public IMessage onMessage(StartPlayerFadeOutToClient message, MessageContext ctx) {
            EnumFadeOutEffectType t = EnumFadeOutEffectType.valueOf(message.type);
            switch (t) {
                case RINGS: {
                    JSG.proxy.addScheduledTaskClientSide(RingsWhiteFadeOut::startFadeOut);
                    break;
                }
                case FTL_IN: 
                case FTL_OUT: {
                    JSG.proxy.addScheduledTaskClientSide(() -> DestinyFTL.jumpIn(t == EnumFadeOutEffectType.FTL_IN));
                    break;
                }
            }
            return null;
        }
    }

    public static enum EnumFadeOutEffectType {
        RINGS(0),
        FTL_IN(1),
        FTL_OUT(2);

        public final int id;

        private EnumFadeOutEffectType(int id) {
            this.id = id;
        }

        public static EnumFadeOutEffectType valueOf(int id) {
            for (EnumFadeOutEffectType type : EnumFadeOutEffectType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return RINGS;
        }
    }
}

