/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet.transportrings;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.ParamsSetResult;

public class SaveRingsParametersToServer
extends PositionedPacket {
    String name;
    int distance;

    public SaveRingsParametersToServer() {
    }

    public SaveRingsParametersToServer(BlockPos pos, String name, int distance) {
        super(pos);
        this.name = name;
        this.distance = distance;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        buf.writeInt(this.distance);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int len = buf.readInt();
        this.name = buf.readCharSequence(len, StandardCharsets.UTF_8).toString();
        this.distance = buf.readInt();
    }

    public static class SaveRingsParametersServerHandler
    implements IMessageHandler<SaveRingsParametersToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(SaveRingsParametersToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(message.pos);
                if (ringsTile != null && ringsTile.setRingsParams(message.name, message.distance) == ParamsSetResult.DUPLICATE_ADDRESS) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.transportrings_block.duplicate_address", new Object[0]), true);
                }
                JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(message.pos, StateTypeEnum.GUI_STATE, ringsTile.getState(StateTypeEnum.GUI_STATE)), player);
            });
            return null;
        }
    }
}

