/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet.stargate;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.stargate.EnumIrisMode;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;

public class SaveIrisCodeToServer
extends PositionedPacket {
    int code;
    EnumIrisMode mode;

    public SaveIrisCodeToServer() {
    }

    public SaveIrisCodeToServer(BlockPos pos, int code, EnumIrisMode mode) {
        super(pos);
        this.code = code;
        this.mode = mode;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.code);
        buf.writeByte((int)this.mode.id);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.code = buf.readInt();
        this.mode = EnumIrisMode.getValue(buf.readByte());
    }

    public static class SaveIrisCodeToServerHandler
    implements IMessageHandler<SaveIrisCodeToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(SaveIrisCodeToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                if (world.func_175625_s(message.pos) instanceof StargateClassicBaseTile) {
                    StargateClassicBaseTile te = (StargateClassicBaseTile)world.func_175625_s(message.pos);
                    te.setIrisCode(message.code);
                    te.setIrisMode(message.mode);
                    JSGPacketHandler.INSTANCE.sendTo((IMessage)new StateUpdatePacketToClient(message.pos, StateTypeEnum.GUI_STATE, te.getState(StateTypeEnum.GUI_STATE)), player);
                }
            });
            return null;
        }
    }
}

