/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import scala.NotImplementedError;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateProviderInterface;
import tauri.dev.jsg.state.StateTypeEnum;

public class StateUpdatePacketToClient
extends PositionedPacket {
    private StateTypeEnum stateType;
    private State state;
    private ByteBuf stateBuf;

    public StateUpdatePacketToClient() {
    }

    public StateUpdatePacketToClient(BlockPos pos, StateTypeEnum stateType, State state) {
        super(pos);
        this.stateType = stateType;
        if (state == null) {
            throw new NullPointerException("State was null! (State type: " + stateType.toString() + "; Pos: " + pos.toString() + ")");
        }
        this.state = state;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stateType.id);
        this.state.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stateType = StateTypeEnum.byId(buf.readInt());
        this.stateBuf = buf.copy();
    }

    public static class StateUpdateClientHandler
    implements IMessageHandler<StateUpdatePacketToClient, IMessage> {
        public IMessage onMessage(StateUpdatePacketToClient message, MessageContext ctx) {
            EntityPlayer player = JSG.proxy.getPlayerClientSide();
            if (player == null) {
                return null;
            }
            World world = player.func_130014_f_();
            JSG.proxy.addScheduledTaskClientSide(() -> {
                StateProviderInterface te = (StateProviderInterface)world.func_175625_s(message.pos);
                try {
                    if (te == null) {
                        return;
                    }
                    State state = te.createState(message.stateType);
                    if (state == null) {
                        throw new NotImplementedError("State not implemented on " + te.toString());
                    }
                    state.fromBytes(message.stateBuf);
                    te.setState(message.stateType, state);
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            });
            return null;
        }
    }
}

