/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.sound.SoundPositionedEnum;

public class SoundPositionedPlayToClient
extends PositionedPacket {
    public SoundPositionedEnum soundEnum;
    public boolean play;

    public SoundPositionedPlayToClient() {
    }

    public SoundPositionedPlayToClient(BlockPos pos, SoundPositionedEnum soundEnum, boolean play) {
        super(pos);
        this.soundEnum = soundEnum;
        this.play = play;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.soundEnum.id);
        buf.writeBoolean(this.play);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.soundEnum = SoundPositionedEnum.valueOf(buf.readInt());
        this.play = buf.readBoolean();
    }

    public static class PlayPositionedSoundClientHandler
    implements IMessageHandler<SoundPositionedPlayToClient, IMessage> {
        public IMessage onMessage(SoundPositionedPlayToClient message, MessageContext ctx) {
            JSG.proxy.addScheduledTaskClientSide(() -> JSG.proxy.playPositionedSoundClientSide(message.pos, message.soundEnum, message.play));
            return null;
        }
    }
}

