/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.packet.PositionedPacket;
import tauri.dev.jsg.packet.StateUpdatePacketToClient;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.props.AncientSignTile;

public class AncientSignSaveToServer
extends PositionedPacket {
    String[] lines = AncientSignTile.getNewLines();
    final int size = 7;

    public AncientSignSaveToServer() {
    }

    public AncientSignSaveToServer(BlockPos pos, String[] lines) {
        super(pos);
        this.lines = lines;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        for (int i = 0; i < 7; ++i) {
            buf.writeInt(this.lines[i].length());
            buf.writeCharSequence((CharSequence)this.lines[i], StandardCharsets.UTF_8);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        for (int i = 0; i < 7; ++i) {
            int len = buf.readInt();
            this.lines[i] = buf.readCharSequence(len, StandardCharsets.UTF_8).toString();
        }
    }

    public static class AncientSignSaveToServerHandler
    implements IMessageHandler<AncientSignSaveToServer, IMessage> {
        public StateUpdatePacketToClient onMessage(AncientSignSaveToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                AncientSignTile te;
                if (world.func_175625_s(message.pos) instanceof AncientSignTile && (te = (AncientSignTile)world.func_175625_s(message.pos)) != null) {
                    te.ancientText = message.lines;
                    te.func_70296_d();
                    te.sendState(StateTypeEnum.RENDERER_UPDATE, te.getState(StateTypeEnum.RENDERER_UPDATE));
                }
            });
            return null;
        }
    }
}

