/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.loader.texture;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.io.IOUtils;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.origins.OriginsLoader;
import tauri.dev.jsg.loader.FolderLoader;
import tauri.dev.jsg.loader.ReloadListener;
import tauri.dev.jsg.loader.texture.Texture;

public class TextureLoader {
    public static final String TEXTURES_PATH = "assets/jsg/textures/tesr";
    private static final int EH_ANIMATED_TEXTURE_SUB_TEXTURES = 185;
    private static final Map<ResourceLocation, Texture> LOADED_TEXTURES = new HashMap<ResourceLocation, Texture>();

    public static Texture getTexture(ResourceLocation resourceLocation) {
        return LOADED_TEXTURES.get(resourceLocation);
    }

    public static boolean isNotTextureLoaded(ResourceLocation resourceLocation) {
        return !LOADED_TEXTURES.containsKey(resourceLocation);
    }

    public static void reloadTextures(IResourceManager resourceManager) throws IOException {
        for (Texture texture : LOADED_TEXTURES.values()) {
            texture.deleteTexture();
        }
        OriginsLoader.registerTextures(LOADED_TEXTURES);
        ArrayList<String> texturePaths = new ArrayList<String>();
        ArrayList<String> ehPaths = new ArrayList<String>();
        block17: for (String texturePath : FolderLoader.getAllFiles(TEXTURES_PATH, ".png", ".jpg")) {
            switch (texturePath = texturePath.replaceFirst("assets/jsg/", "")) {
                case "textures/tesr/event_horizon_animated_unstable.jpg": 
                case "textures/tesr/event_horizon_animated.jpg": 
                case "textures/tesr/event_horizon_animated_kawoosh.jpg": 
                case "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg": {
                    ehPaths.add(texturePath);
                    continue block17;
                }
            }
            texturePaths.add(texturePath);
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"JSG - General textures", (int)texturePaths.size());
        long start = System.currentTimeMillis();
        JSG.info("Started loading textures...");
        for (String texturePath : texturePaths) {
            TextureLoader.loadTexture(progressBar, texturePath, resourceManager);
        }
        JSG.info("Loaded " + texturePaths.size() + " textures in " + (System.currentTimeMillis() - start) + " ms");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        if (!JSGConfig.Stargate.eventHorizon.disableAnimatedEventHorizon && !JSGConfig.General.devConfig.enableDevMode) {
            progressBar = ProgressManager.push((String)"JSG - Animated textures", (int)ehPaths.size());
            start = System.currentTimeMillis();
            JSG.info("Started loading event horizon textures...");
            Iterator iterator = ehPaths.iterator();
            block19: while (iterator.hasNext()) {
                String texturePath;
                switch (texturePath = (String)iterator.next()) {
                    case "textures/tesr/event_horizon_animated_kawoosh.jpg": 
                    case "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg": {
                        TextureLoader.loadEH(progressBar, texturePath, resourceManager);
                        continue block19;
                    }
                }
                TextureLoader.loadTexture(progressBar, texturePath, resourceManager);
            }
            JSG.info("Loaded " + ehPaths.size() + " textures in " + (System.currentTimeMillis() - start) + " ms");
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        } else if (JSGConfig.General.debug.logTexturesLoading) {
            JSG.info("Skipping loading EH textures!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTexture(ProgressManager.ProgressBar progressBar, String texturePath, IResourceManager resourceManager) {
        progressBar.step(texturePath.replaceFirst("textures/tesr/", ""));
        ResourceLocation resourceLocation = new ResourceLocation("jsg", texturePath);
        IResource resource = null;
        try {
            resource = resourceManager.func_110536_a(resourceLocation);
            if (JSGConfig.General.debug.logTexturesLoading) {
                JSG.info("Loading texture: " + texturePath);
            }
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            LOADED_TEXTURES.put(resourceLocation, new Texture(bufferedImage));
            ++ReloadListener.LoadingStats.loadedTextures;
        }
        catch (IOException e) {
            JSG.error("Failed to load texture " + texturePath);
            e.printStackTrace();
            ++ReloadListener.LoadingStats.notLoadedTextures;
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEH(ProgressManager.ProgressBar progressBar, String texturePath, IResourceManager resourceManager) {
        ReloadListener.LoadingStats.loadedAnimatedEHs = true;
        progressBar.step(texturePath.replaceFirst("textures/tesr/", ""));
        ResourceLocation resourceLocation = new ResourceLocation("jsg", texturePath);
        IResource resource = null;
        try {
            resource = resourceManager.func_110536_a(resourceLocation);
            if (JSGConfig.General.debug.logTexturesLoading) {
                JSG.info("Loading texture: " + texturePath);
            }
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            LOADED_TEXTURES.put(resourceLocation, new Texture(bufferedImage));
            ++ReloadListener.LoadingStats.loadedTextures;
            if (!JSGConfig.Stargate.eventHorizon.disableNewKawoosh) {
                ProgressManager.ProgressBar subProgressBar = ProgressManager.push((String)"JSG - Event Horizon Sub-Textures", (int)185);
                int onePiece = bufferedImage.getWidth() / 14;
                for (int i = 0; i < 185; ++i) {
                    int texIndex = i % 185;
                    int x = texIndex % 14;
                    int y = texIndex / 14;
                    String subPath = texturePath + "_" + x + "." + y;
                    subProgressBar.step(x + ":" + y);
                    if (JSGConfig.General.debug.logTexturesLoading) {
                        JSG.info("Loading sub-texture: " + subPath);
                    }
                    BufferedImage texturePart = bufferedImage.getSubimage(x * onePiece, y * onePiece, onePiece, onePiece);
                    LOADED_TEXTURES.put(new ResourceLocation("jsg", subPath), new Texture(texturePart));
                    ++ReloadListener.LoadingStats.loadedTextures;
                }
                ReloadListener.LoadingStats.loadedNewKawoosh = true;
                ProgressManager.pop((ProgressManager.ProgressBar)subProgressBar);
            }
        }
        catch (IOException e) {
            JSG.error("Failed to load texture " + texturePath);
            e.printStackTrace();
            ++ReloadListener.LoadingStats.notLoadedTextures;
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    public static ResourceLocation getTextureResource(String texture) {
        return new ResourceLocation("jsg", "textures/tesr/" + texture);
    }

    public static ResourceLocation getBlockTexture(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher ren = minecraft.func_175602_ab();
        String blockTexture = ((BakedQuad)ren.func_184389_a(blockState).func_188616_a(blockState, EnumFacing.NORTH, 0L).get(0)).func_187508_a().func_94215_i();
        String domain = "minecraft";
        String path = blockTexture;
        int domainSeparator = blockTexture.indexOf(58);
        if (domainSeparator >= 0) {
            path = blockTexture.substring(domainSeparator + 1);
            if (domainSeparator > 1) {
                domain = blockTexture.substring(0, domainSeparator);
            }
        }
        String resourcePath = "textures/" + path + ".png";
        return new ResourceLocation(domain.toLowerCase(), resourcePath);
    }
}

