/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.loader.model;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class OBJModel {
    private int drawCount;
    private boolean modelInitialized;
    private int vId;
    private int tId;
    private int nId;
    private int iId;
    private boolean hasTex;
    private float[] vertices;
    private float[] textureCoords;
    private float[] normals;
    private int[] indices;

    public OBJModel(float[] vertices, float[] textureCoords, float[] normals, int[] indices, boolean hasTex) {
        this.vertices = vertices;
        this.textureCoords = textureCoords;
        this.normals = normals;
        this.indices = indices;
        this.hasTex = hasTex;
        this.modelInitialized = false;
    }

    public void initializeModel() {
        this.drawCount = this.indices.length;
        this.vId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vId);
        GL15.glBufferData((int)34962, (FloatBuffer)this.createFloatBuffer(this.vertices), (int)35044);
        if (this.hasTex) {
            this.tId = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.tId);
            GL15.glBufferData((int)34962, (FloatBuffer)this.createFloatBuffer(this.textureCoords), (int)35044);
        }
        this.nId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.nId);
        GL15.glBufferData((int)34962, (FloatBuffer)this.createFloatBuffer(this.normals), (int)35044);
        this.iId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.iId);
        GL15.glBufferData((int)34963, (IntBuffer)this.createIntBuffer(this.indices), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        this.modelInitialized = true;
    }

    public void render() {
        if (!this.modelInitialized) {
            this.initializeModel();
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32885);
        if (this.hasTex) {
            GL11.glEnableClientState((int)32888);
        }
        GL15.glBindBuffer((int)34962, (int)this.vId);
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        if (this.hasTex) {
            GL15.glBindBuffer((int)34962, (int)this.tId);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)0, (long)0L);
        }
        GL15.glBindBuffer((int)34962, (int)this.nId);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34963, (int)this.iId);
        GL11.glDrawElements((int)4, (int)this.drawCount, (int)5125, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32885);
        if (this.hasTex) {
            GL11.glDisableClientState((int)32888);
        }
    }

    private FloatBuffer createFloatBuffer(float[] input) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)input.length);
        ((Buffer)buffer.put(input)).flip();
        return buffer;
    }

    private IntBuffer createIntBuffer(int[] input) {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)input.length);
        ((Buffer)buffer.put(input)).flip();
        return buffer;
    }
}

