/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.loader.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.origins.OriginsLoader;
import tauri.dev.jsg.loader.FolderLoader;
import tauri.dev.jsg.loader.ReloadListener;
import tauri.dev.jsg.loader.model.OBJLoader;
import tauri.dev.jsg.loader.model.OBJModel;

public class ModelLoader {
    public static final String MODELS_PATH = "assets/jsg/models/tesr";
    private static final Map<ResourceLocation, OBJModel> LOADED_MODELS = new HashMap<ResourceLocation, OBJModel>();

    public static OBJModel getModel(ResourceLocation resourceLocation) {
        return LOADED_MODELS.get(resourceLocation);
    }

    public static void reloadModels() throws IOException {
        LOADED_MODELS.clear();
        List<String> modelPaths = FolderLoader.getAllFiles(MODELS_PATH, ".obj");
        for (String poo : JSGConfig.Stargate.pointOfOrigins.additionalOrigins) {
            int i = Integer.parseInt(poo.split(":")[0]);
            String s = "assets/jsg/models/tesr/milkyway/origin_" + i + ".obj";
            if (!modelPaths.contains(s)) {
                modelPaths.add(s);
            }
            if (!modelPaths.contains(s = "assets/jsg/models/tesr/milkyway/origin_" + i + "_light.obj")) {
                modelPaths.add(s);
            }
            if (modelPaths.contains(s = "assets/jsg/models/tesr/milkyway/ring/origin_" + i + ".obj")) continue;
            modelPaths.add(s);
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"JSG - General models", (int)modelPaths.size());
        long start = System.currentTimeMillis();
        JSG.info("Started loading models...");
        for (String modelPath : modelPaths) {
            String modelResourcePath = modelPath.replaceFirst("assets/jsg/", "");
            if (JSGConfig.General.debug.logTexturesLoading) {
                JSG.info("Loading model: " + modelResourcePath);
            }
            progressBar.step(modelResourcePath.replaceFirst("models/", ""));
            InputStream stream = JSG.class.getClassLoader().getResourceAsStream(modelPath);
            OBJModel model = OBJLoader.loadModel(stream);
            if (model == null) {
                ++ReloadListener.LoadingStats.notLoadedModels;
                continue;
            }
            LOADED_MODELS.put(new ResourceLocation("jsg", modelResourcePath), model);
            ++ReloadListener.LoadingStats.loadedModels;
        }
        OriginsLoader.loadModels(LOADED_MODELS);
        JSG.info("Loaded " + modelPaths.size() + " models in " + (System.currentTimeMillis() - start) + " ms");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public static ResourceLocation getModelResource(String model) {
        return new ResourceLocation("jsg", "models/tesr/" + model);
    }
}

