/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.tools;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.capability.WeaponCapabilityProvider;
import tauri.dev.jsg.capability.endpoint.ItemEndpointCapability;
import tauri.dev.jsg.capability.endpoint.ItemEndpointInterface;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.entity.JSGEnergyProjectile;
import tauri.dev.jsg.item.renderer.CustomModel;
import tauri.dev.jsg.item.renderer.CustomModelItemInterface;
import tauri.dev.jsg.power.stargate.StargateItemEnergyStorage;

public abstract class EnergyWeapon
extends Item
implements CustomModelItemInterface {
    private final int maxEnergyStored;
    private final int energyPerShot;
    public String itemName;
    private CustomModel customModel;

    public EnergyWeapon(String itemName, int maxEnergyStored, int energyPerShot) {
        this.itemName = itemName;
        this.maxEnergyStored = maxEnergyStored;
        this.energyPerShot = energyPerShot;
        this.setRegistryName(new ResourceLocation("jsg", this.itemName));
        this.func_77655_b("jsg." + this.itemName);
        this.func_77625_d(1);
        this.func_77637_a(JSGCreativeTabsHandler.JSG_WEAPONS_CREATIVE_TAB);
    }

    private static void checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            EnergyWeapon.initNBT(stack);
        }
    }

    private static void initNBT(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("scope", false);
        stack.func_77982_d(compound);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            StargateItemEnergyStorage energyStorage = (StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage == null) {
                return;
            }
            energyStorage.setEnergyStored(energyStorage.getMaxEnergyStored());
            items.add((Object)stack);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            EnergyWeapon.checkNBT(player.func_184586_b(hand));
            ItemStack stack = player.func_184586_b(hand);
            NBTTagCompound compound = stack.func_77978_p();
            if (!player.func_70093_af()) {
                StargateItemEnergyStorage energyStorage = (StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (energyStorage != null && energyStorage.extractEnergy(this.energyPerShot, true) >= this.energyPerShot) {
                    this.playShootSound(world, (Entity)player);
                    player.func_184811_cZ().func_185145_a((Item)this, this.getWeaponCoolDown());
                    world.func_72838_d((Entity)JSGEnergyProjectile.createEnergyBall(world, (EntityLivingBase)player, this));
                    energyStorage.extractEnergy(this.energyPerShot, false);
                }
            } else if (compound != null) {
                compound.func_74757_a("scope", !compound.func_74767_n("scope"));
                stack.func_77982_d(compound);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        ((ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)).removeEndpoint();
        return super.onDroppedByPlayer(stack, player);
    }

    public abstract void playShootSound(World var1, Entity var2);

    public abstract int getWeaponCoolDown();

    public abstract DamageSource getDamageSource(Entity var1, Entity var2);

    public void setEnergyBallParams(JSGEnergyProjectile projectile) {
        projectile.maxAliveTime = 5;
        projectile.damage = 5.0f;
        projectile.igniteGround = true;
        projectile.paralyze = false;
        projectile.explode = false;
        projectile.invisible = true;
        projectile.damageSource = this.getDamageSource((Entity)projectile, (Entity)projectile.field_70235_a);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add(JSG.getInProgress());
        tooltip.add("");
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            tooltip.add("NBTs are broken! This is a bug!");
            return;
        }
        String energy = String.format("%,d", energyStorage.getEnergyStored());
        String capacity = String.format("%,d", energyStorage.getMaxEnergyStored());
        tooltip.add(energy + " / " + capacity + " RF");
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() * 100.0f)) + " %";
        tooltip.add(energyPercent);
        tooltip.add("");
        tooltip.add(JSG.proxy.localize("item.jsg.energyWeapon.available_shots", new Object[0]) + " " + (int)Math.floor((float)energyStorage.getEnergyStored() / (float)this.energyPerShot) + "/" + (int)Math.floor((float)energyStorage.getMaxEnergyStored() / (float)this.energyPerShot));
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() != newStack.func_77973_b()) {
            NBTTagCompound compound;
            if (oldStack.func_77973_b() instanceof EnergyWeapon && oldStack.func_77978_p() != null) {
                compound = oldStack.func_77978_p();
                compound.func_74757_a("scope", false);
                oldStack.func_77982_d(compound);
            }
            if (newStack.func_77973_b() instanceof EnergyWeapon && newStack.func_77978_p() != null) {
                compound = newStack.func_77978_p();
                compound.func_74757_a("scope", false);
                newStack.func_77982_d(compound);
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new WeaponCapabilityProvider(stack, nbt, this.maxEnergyStored);
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energyStorage == null) {
            return 1.0;
        }
        return 1.0 - (double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored();
    }
}

