/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.notebook;

import java.util.List;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.item.notebook.NotebookTEISR;
import tauri.dev.jsg.item.notebook.PageNotebookItem;
import tauri.dev.jsg.item.renderer.CustomModel;
import tauri.dev.jsg.item.renderer.CustomModelItemInterface;

public class NotebookItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "notebook";
    private CustomModel customModel;

    public NotebookItem() {
        this.setRegistryName("jsg:notebook");
        this.func_77655_b("jsg.notebook");
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            NBTTagList list = compound.func_150295_c("addressList", 10);
            for (NBTBase item : list) {
                NBTTagCompound pageTag = (NBTTagCompound)item;
                tooltip.add(TextFormatting.AQUA + PageNotebookItem.getNameFromCompound(pageTag));
            }
        }
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new NotebookTEISR();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        int newSelected;
        if (oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        if (!oldStack.func_77942_o() || !newStack.func_77942_o()) {
            return true;
        }
        int oldSelected = oldStack.func_77978_p().func_74762_e("selected");
        return oldSelected != (newSelected = newStack.func_77978_p().func_74762_e("selected"));
    }

    public static NBTTagCompound getSelectedPageFromCompound(NBTTagCompound compound) {
        int selected = compound.func_74762_e("selected");
        NBTTagList list = compound.func_150295_c("addressList", 10);
        return list.func_150305_b(selected);
    }

    public static void setNameForIndex(NBTTagList list, int index, String name) {
        NBTTagCompound page = list.func_150305_b(index);
        PageNotebookItem.setName(page, name);
    }
}

