/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.notebook;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.notebook.NotebookActionEnum;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;

public class NotebookActionPacketToServer
implements IMessage {
    private NotebookActionEnum action;
    private EnumHand hand;
    private boolean next;

    public NotebookActionPacketToServer() {
    }

    public NotebookActionPacketToServer(NotebookActionEnum action, EnumHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.next = next;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == EnumHand.MAIN_HAND ? 0 : 1);
        buf.writeBoolean(this.next);
    }

    public void fromBytes(ByteBuf buf) {
        this.action = NotebookActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.next = buf.readBoolean();
    }

    public static class NotebookActionPacketServerHandler
    implements IMessageHandler<NotebookActionPacketToServer, IMessage> {
        public IMessage onMessage(NotebookActionPacketToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                if (stack.func_77973_b() == JSGItems.NOTEBOOK_ITEM && stack.func_77942_o()) {
                    NBTTagCompound compound = stack.func_77978_p();
                    int selected = compound.func_74762_e("selected");
                    switch (message.action) {
                        case ADDRESS_CHANGE: {
                            int addressCount = compound.func_150295_c("addressList", 10).func_74745_c();
                            if (message.next && selected < addressCount - 1) {
                                compound.func_74768_a("selected", (int)((byte)(selected + 1)));
                                JSGSoundHelper.playSoundEvent((World)world, player.func_180425_c(), SoundEventEnum.PAGE_FLIP);
                            }
                            if (message.next || selected <= 0) break;
                            compound.func_74768_a("selected", (int)((byte)(selected - 1)));
                            JSGSoundHelper.playSoundEvent((World)world, player.func_180425_c(), SoundEventEnum.PAGE_FLIP);
                        }
                    }
                }
            });
            return null;
        }
    }
}

