/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.mysterious;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.advancements.JSGAdvancements;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.notebook.PageNotebookItem;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.worldgen.structures.stargate.StargateGenerator;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;

public abstract class AbstractPageMysteriousItem
extends Item {
    public static final String BASE_NAME = "page_mysterious";
    protected final SymbolTypeEnum symbolType;
    protected final int dimensionToSpawn;

    public AbstractPageMysteriousItem(String typeName, SymbolTypeEnum symbolType, int dimensionToSpawn) {
        this.symbolType = symbolType;
        this.dimensionToSpawn = dimensionToSpawn;
        this.setRegistryName("jsg:page_mysterious_" + typeName);
        this.func_77655_b("jsg.page_mysterious_" + typeName);
        this.func_77637_a(JSGCreativeTabsHandler.JSG_ITEMS_CREATIVE_TAB);
    }

    public void func_77624_a(@Nonnull ItemStack stack, World worldIn, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.ITALIC + JSG.proxy.localize("item.jsg.page_mysterious.tooltip", new Object[0]));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            GeneratedStargate stargate;
            this.sendPlayerMessageAboutGeneration(player, true, false);
            if (JSGConfig.WorldGen.mystPage.pageCooldown > 0) {
                player.func_184811_cZ().func_185145_a((Item)this, JSGConfig.WorldGen.mystPage.pageCooldown);
            }
            if ((stargate = StargateGenerator.mystPageGeneration(world, this.symbolType, this.dimensionToSpawn, player)) != null) {
                this.givePlayerPage(player, hand, stargate);
                this.sendPlayerMessageAboutGeneration(player, false, true);
                if (player instanceof EntityPlayerMP) {
                    JSGAdvancements.MYST_PAGE.trigger((EntityPlayerMP)player);
                }
            } else {
                player.func_184811_cZ().func_185145_a((Item)this, 0);
                this.sendPlayerMessageAboutGeneration(player, false, false);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void givePlayerPage(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, GeneratedStargate stargate) {
        NBTTagCompound compound = PageNotebookItem.getCompoundFromAddress(stargate.address, stargate.hasUpgrade, stargate.path, stargate.originId);
        ItemStack stack = new ItemStack((Item)JSGItems.PAGE_NOTEBOOK_ITEM, 1, 1);
        stack.func_77982_d(compound);
        ItemStack held = player.func_184586_b(hand);
        held.func_190918_g(1);
        if (held.func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else {
            player.func_184611_a(hand, held);
            player.func_191521_c(stack);
        }
    }

    protected void sendPlayerMessageAboutGeneration(@Nonnull EntityPlayer player, boolean generationStart, boolean generationSuccess) {
        if (generationStart) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.page_mysterious.generation.start", new Object[0]), true);
        } else if (generationSuccess) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.page_mysterious.generation.success", new Object[0]), true);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.page_mysterious.generation.failed", new Object[0]), true);
        }
    }
}

