/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.linkable.gdo;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.capability.endpoint.ItemEndpointCapability;
import tauri.dev.jsg.capability.endpoint.ItemEndpointInterface;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.LinkAbleCapabilityProvider;
import tauri.dev.jsg.item.linkable.gdo.GDOMode;
import tauri.dev.jsg.item.linkable.gdo.GDOTEISR;
import tauri.dev.jsg.item.oc.ItemOCMessage;
import tauri.dev.jsg.item.renderer.CustomModel;
import tauri.dev.jsg.item.renderer.CustomModelItemInterface;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.LinkingHelper;

public class GDOItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "gdo";
    private CustomModel customModel;

    public GDOItem() {
        this.setRegistryName(new ResourceLocation("jsg", ITEM_NAME));
        this.func_77655_b("jsg.gdo");
        this.func_77637_a(JSGCreativeTabsHandler.JSG_TOOLS_CREATIVE_TAB);
    }

    private static void checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            GDOItem.initNBT(stack);
        }
    }

    private static void initNBT(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("mode", GDOMode.CODE_SENDER.id);
        compound.func_74774_a("selected", (byte)0);
        compound.func_74782_a("saved", (NBTBase)new NBTTagList());
        stack.func_77982_d(compound);
    }

    public static boolean isLinked(ItemStack itemStack) {
        if (itemStack.func_77973_b() == JSGItems.GDO && itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74764_b("linkedGate");
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            GDOItem.initNBT(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new GDOTEISR();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new LinkAbleCapabilityProvider();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    /*
     * Unable to fully structure code
     */
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        block6: {
            block7: {
                block8: {
                    if (world.field_72995_K) break block6;
                    GDOItem.checkNBT(stack);
                    compound = stack.func_77978_p();
                    if (world.func_82737_E() % 20L != 0L || !isSelected) break block7;
                    pos = entity.func_180425_c();
                    reachSquared = JSGConfig.DialHomeDevice.mechanics.universeDialerReach * JSGConfig.DialHomeDevice.mechanics.universeDialerReach;
                    mode = GDOMode.valueOf(compound.func_74771_c("mode"));
                    if (!mode.linkable) break block7;
                    if (!compound.func_74764_b(mode.tagPosName)) break block8;
                    tilePos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
                    if (world.func_175625_s(tilePos) == null || !(world.func_175625_s(tilePos) instanceof StargateAbstractBaseTile) || tilePos.func_177951_i((Vec3i)pos) > (double)reachSquared) {
                        compound.func_82580_o(mode.tagPosName);
                    }
                    break block7;
                }
                found = false;
                blacklist = new ArrayList<BlockPos>();
                loop = 0;
                while ((targetPos = this.getNearest(world, pos, blacklist)) != null) {
                    if (!(world.func_175625_s(targetPos) instanceof StargateAbstractBaseTile)) ** GOTO lbl-1000
                    switch (1.$SwitchMap$tauri$dev$jsg$item$linkable$gdo$GDOMode[mode.ordinal()]) {
                        case 1: 
                        case 2: {
                            gateTile = (StargateAbstractBaseTile)world.func_175625_s(targetPos);
                            if (gateTile == null || !gateTile.isMerged()) {
                                blacklist.add(targetPos);
                                break;
                            }
                            compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                            found = true;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            ++loop;
                        }
                    }
                    if (!found && loop < 100) continue;
                }
            }
            endpointStack = (ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null);
            endpointStack.checkAndUpdateEndpoint(world.func_82737_E());
        }
    }

    public BlockPos getNearest(World world, BlockPos pos, ArrayList<BlockPos> blacklist) {
        return LinkingHelper.findClosestPos(world, pos, new BlockPos(JSGConfig.DialHomeDevice.mechanics.universeDialerReach, 10, JSGConfig.DialHomeDevice.mechanics.universeDialerReach), JSGBlocks.STARGATE_BASE_BLOCKS, blacklist);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        ((ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)).removeEndpoint();
        return super.onDroppedByPlayer(stack, player);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K) {
            GDOItem.checkNBT(player.func_184586_b(hand));
            NBTTagCompound compound = player.func_184586_b(hand).func_77978_p();
            GDOMode mode = GDOMode.valueOf(compound.func_74771_c("mode"));
            byte selected = compound.func_74771_c("selected");
            if (mode.linkable && !compound.func_74764_b(mode.tagPosName)) {
                return super.func_77659_a(world, player, hand);
            }
            if (mode == GDOMode.OC) {
                NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
                NBTTagCompound selectedCompound = tagList.func_150305_b((int)selected);
                ItemOCMessage message = new ItemOCMessage(selectedCompound);
                JSG.debug("Sending OC message: " + message.toString());
                JSG.ocWrapper.sendWirelessPacketPlayer(ITEM_NAME, player, player.func_184586_b(hand), message.address, message.port, message.getData());
            }
        }
        return super.func_77659_a(world, player, hand);
    }
}

