/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.linkable.dialer;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.capability.endpoint.ItemEndpointCapability;
import tauri.dev.jsg.capability.endpoint.ItemEndpointInterface;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.LinkAbleCapabilityProvider;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerMode;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerTEISR;
import tauri.dev.jsg.item.oc.ItemOCMessage;
import tauri.dev.jsg.item.renderer.CustomModel;
import tauri.dev.jsg.item.renderer.CustomModelItemInterface;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.NearbyGate;
import tauri.dev.jsg.stargate.StargateClosedReasonEnum;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.tileentity.props.DestinyCountDownTile;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportRings;
import tauri.dev.jsg.util.EnumKeyInterface;
import tauri.dev.jsg.util.EnumKeyMap;
import tauri.dev.jsg.util.LinkingHelper;

public class UniverseDialerItem
extends Item
implements CustomModelItemInterface {
    public static final String ITEM_NAME = "universe_dialer";
    private CustomModel customModel;

    public UniverseDialerItem() {
        this.setRegistryName(new ResourceLocation("jsg", ITEM_NAME));
        this.func_77655_b("jsg.universe_dialer");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(JSGCreativeTabsHandler.JSG_TOOLS_CREATIVE_TAB);
    }

    private static void checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            UniverseDialerItem.initNBT(stack);
        }
    }

    public static void initNBT(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        switch (UniverseDialerVariants.valueOf(stack.func_77952_i())) {
            case NORMAL: {
                compound.func_74774_a("mode", UniverseDialerMode.NEARBY.id);
                compound.func_74774_a("selected", (byte)0);
                compound.func_74782_a("saved", (NBTBase)new NBTTagList());
                break;
            }
        }
        stack.func_77982_d(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            UniverseDialerItem.initNBT(stack);
            items.add((Object)stack);
        }
    }

    @Override
    public void setCustomModel(CustomModel customModel) {
        this.customModel = customModel;
    }

    public ItemCameraTransforms.TransformType getLastTransform() {
        return this.customModel.lastTransform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntityItemStackRenderer createTEISR() {
        return new UniverseDialerTEISR();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77952_i() == UniverseDialerVariants.BROKEN.meta) {
            return null;
        }
        return new LinkAbleCapabilityProvider();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == UniverseDialerVariants.BROKEN.meta) {
            return "item.jsg.universe_dialer.broken";
        }
        return super.func_77667_c(stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            switch (UniverseDialerVariants.valueOf(stack.func_77952_i())) {
                case NORMAL: {
                    NBTTagList list = stack.func_77978_p().func_150295_c("saved", 10);
                    tooltip.add(TextFormatting.GRAY + JSG.proxy.localize("item.jsg.universe_dialer.saved_gates", list.func_74745_c()));
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound compound = list.func_150305_b(i);
                        if (!compound.func_74764_b("name")) continue;
                        tooltip.add(TextFormatting.AQUA + compound.func_74779_i("name"));
                    }
                    break;
                }
            }
        }
    }

    public BlockPos getNearest(World world, BlockPos pos, ArrayList<BlockPos> blacklist, UniverseDialerMode mode) {
        return LinkingHelper.findClosestPos(world, pos, new BlockPos(JSGConfig.DialHomeDevice.mechanics.universeDialerReach, 40, JSGConfig.DialHomeDevice.mechanics.universeDialerReach), mode.matchBlocks, blacklist);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            ItemEndpointInterface endpointStack;
            UniverseDialerItem.checkNBT(stack);
            if (stack.func_77952_i() == UniverseDialerVariants.BROKEN.meta) {
                return;
            }
            NBTTagCompound compound = stack.func_77978_p();
            if (compound != null && compound.func_74764_b("timerCountTo")) {
                long time = compound.func_74763_f("timerCountTo");
                long actualTicks = time - entity.func_130014_f_().func_82737_E();
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP p = (EntityPlayerMP)entity;
                    if (actualTicks == 0L) {
                        JSGSoundHelper.playSoundToPlayer(p, SoundEventEnum.DESTINY_COUNTDOWN_STOP, p.func_180425_c());
                    }
                    if (actualTicks == 1200L) {
                        JSGSoundHelper.playSoundToPlayer(p, SoundEventEnum.DESTINY_COUNTDOWN_ONE_MINUTE, p.func_180425_c());
                    }
                }
            }
            boolean wasLinked = false;
            if (world.func_82737_E() % 20L == 0L && isSelected && compound != null) {
                BlockPos pos = entity.func_180425_c();
                int reachSquared = JSGConfig.DialHomeDevice.mechanics.universeDialerReach * JSGConfig.DialHomeDevice.mechanics.universeDialerReach * 2;
                UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
                compound.func_74757_a("serverSideEnabledFastDial", false);
                if (mode.linkable) {
                    BlockPos targetPos;
                    if (compound.func_74764_b(mode.tagPosName)) {
                        wasLinked = true;
                        BlockPos tilePos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
                        if (!JSGBlocks.isInBlocksArray(world.func_180495_p(tilePos).func_177230_c(), mode.matchBlocks) || tilePos.func_177951_i((Vec3i)pos) > (double)reachSquared) {
                            compound.func_82580_o(mode.tagPosName);
                        }
                    }
                    boolean found = false;
                    ArrayList<BlockPos> blacklist = new ArrayList<BlockPos>();
                    int loop = 0;
                    while ((targetPos = this.getNearest(world, pos, blacklist, mode)) != null) {
                        block30: {
                            switch (mode) {
                                case MEMORY: 
                                case NEARBY: {
                                    StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(targetPos);
                                    if (gateTile == null || !gateTile.isMerged() || !(gateTile instanceof StargateUniverseBaseTile)) {
                                        blacklist.add(targetPos);
                                        break block30;
                                    } else {
                                        StargateUniverseBaseTile uniTile = (StargateUniverseBaseTile)gateTile;
                                        NBTTagList nearbyList = new NBTTagList();
                                        try {
                                            UniverseDialerItem.addrToBytes(gateTile.getDialedAddress(), compound, "dialedAddress");
                                            UniverseDialerItem.addrToBytes(((StargateUniverseBaseTile)gateTile).getAddressToDial(), compound, "toDialAddress");
                                            compound.func_74768_a("gateStatus", gateTile.getStargateState().id);
                                            compound.func_74757_a("serverSideEnabledFastDial", ((StargateClassicBaseTile)gateTile).getConfig().getOption(StargateClassicBaseTile.ConfigOptions.ENABLE_FAST_DIAL.id).getBooleanValue());
                                            ArrayList<NearbyGate> foundList = uniTile.getNearbyGates(SymbolTypeEnum.UNIVERSE, false, false);
                                            if (foundList != null) {
                                                for (NearbyGate nearbyGate : foundList) {
                                                    NBTTagCompound entryCompound = nearbyGate.address.serializeNBT();
                                                    entryCompound.func_74757_a("hasUpgrade", nearbyGate.symbolsNeeded > 7);
                                                    nearbyList.func_74742_a((NBTBase)entryCompound);
                                                }
                                            }
                                            compound.func_74782_a(UniverseDialerMode.NEARBY.tagListName, (NBTBase)nearbyList);
                                            compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                            found = true;
                                        }
                                        catch (ConcurrentModificationException e) {
                                            JSG.error("Error while iterating nearby stargates occurred", e);
                                            if (entity instanceof EntityPlayer) {
                                                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.dialer_broke", new Object[0]), true);
                                            }
                                            UniverseDialerItem.broke(stack);
                                        }
                                        break;
                                    }
                                }
                                case RINGS: {
                                    TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(targetPos);
                                    if (ringsTile == null) {
                                        blacklist.add(targetPos);
                                        break block30;
                                    } else {
                                        NBTTagList ringsList = new NBTTagList();
                                        for (TransportRings rings : ringsTile.ringsMap.values()) {
                                            ringsList.func_74742_a((NBTBase)rings.serializeNBT());
                                        }
                                        compound.func_74782_a(mode.tagListName, (NBTBase)ringsList);
                                        compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                        found = true;
                                        break;
                                    }
                                }
                                case GATE_INFO: {
                                    TileEntity tileEntity = world.func_175625_s(targetPos);
                                    if (!(tileEntity instanceof StargateClassicBaseTile)) break;
                                    StargateClassicBaseTile t = (StargateClassicBaseTile)tileEntity;
                                    compound.func_74757_a("serverSideEnabledFastDial", t.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.ENABLE_FAST_DIAL.id).getBooleanValue());
                                    compound.func_74768_a("gateStatus", t.getStargateState().id);
                                    compound.func_74778_a("gateOpenTime", t.getOpenedSeconds() > 0L ? t.getOpenedSecondsToDisplayAsMinutes() : "CLOSED");
                                    compound.func_74778_a("gateIrisState", t.hasIris() ? t.getIrisState().toString() : "MISSING");
                                    compound.func_74778_a("gateLastSymbol", t.getDialedAddress().size() > 0 ? t.getDialedAddress().get(t.getDialedAddress().size() - 1).toString() + " (" + t.getDialedAddress().size() + ")" : "-- (0)");
                                    if (t.getStargateState().notInitiating()) {
                                        compound.func_74778_a("gateLastSymbol", "INCOMING");
                                    }
                                    compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                    found = true;
                                    break;
                                }
                                case COUNTDOWN: {
                                    TileEntity timerTile = world.func_175625_s(targetPos);
                                    if (!(timerTile instanceof DestinyCountDownTile)) break;
                                    DestinyCountDownTile timerTileCasted = (DestinyCountDownTile)timerTile;
                                    compound.func_74772_a("timerCountTo", timerTileCasted.countdownTo);
                                    compound.func_74772_a(mode.tagPosName, targetPos.func_177986_g());
                                    found = true;
                                }
                            }
                            if (found && !wasLinked && entity instanceof EntityPlayerMP) {
                                JSGSoundHelper.playSoundToPlayer((EntityPlayerMP)entity, SoundEventEnum.UNIVERSE_DIALER_CONNECTED, entity.func_180425_c());
                            }
                            ++loop;
                        }
                        if (!found && loop < 100) continue;
                    }
                }
            }
            if ((endpointStack = (ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)) != null) {
                endpointStack.checkAndUpdateEndpoint(world.func_82737_E());
            }
        }
    }

    private static void addrToBytes(StargateAddress address, NBTTagCompound compound, String baseName) {
        if (compound == null || address == null || baseName == null) {
            return;
        }
        compound.func_74774_a(baseName + "_addressLength", (byte)address.getSize());
        compound.func_74774_a(baseName + "_symbolType", (byte)address.getSymbolType().id);
        for (int i = 0; i < address.getSize(); ++i) {
            compound.func_74774_a(baseName + "_" + i, (byte)address.get(i).getId());
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (stack.func_77952_i() != UniverseDialerVariants.BROKEN.meta) {
            ((ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null)).removeEndpoint();
        }
        return super.onDroppedByPlayer(stack, player);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_77952_i() == UniverseDialerVariants.NORMAL.meta) {
            UniverseDialerItem.checkNBT(player.func_184586_b(hand));
            NBTTagCompound compound = player.func_184586_b(hand).func_77978_p();
            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
            byte selected = compound.func_74771_c("selected");
            if (mode.linkable && !compound.func_74764_b(mode.tagPosName)) {
                return super.func_77659_a(world, player, hand);
            }
            BlockPos linkedPos = BlockPos.func_177969_a((long)compound.func_74763_f(mode.tagPosName));
            NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
            if (selected >= tagList.func_74745_c()) {
                return super.func_77659_a(world, player, hand);
            }
            NBTTagCompound selectedCompound = tagList.func_150305_b((int)selected);
            block0 : switch (mode) {
                case MEMORY: 
                case NEARBY: {
                    StargateUniverseBaseTile gateTile = (StargateUniverseBaseTile)world.func_175625_s(linkedPos);
                    if (gateTile == null) break;
                    switch (gateTile.getStargateState()) {
                        case IDLE: {
                            int maxSymbols = SymbolUniverseEnum.getMaxSymbolsDisplay(selectedCompound.func_74767_n("hasUpgrade"));
                            gateTile.dialAddress(new StargateAddress(selectedCompound), maxSymbols);
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.dial_start", new Object[0]), true);
                            if (!(player instanceof EntityPlayerMP)) break block0;
                            JSGSoundHelper.playSoundToPlayer((EntityPlayerMP)player, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.func_180425_c());
                            break block0;
                        }
                        case ENGAGED_INITIATING: {
                            gateTile.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            if (!(player instanceof EntityPlayerMP)) break block0;
                            JSGSoundHelper.playSoundToPlayer((EntityPlayerMP)player, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.func_180425_c());
                            break block0;
                        }
                        case ENGAGED: {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.dhd_block.incoming_wormhole_warn", new Object[0]), true);
                            break block0;
                        }
                    }
                    if (gateTile.getStargateState() == EnumStargateState.DIALING && gateTile.abortDialingSequence()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.aborting", new Object[0]), true);
                        if (!(player instanceof EntityPlayerMP)) break;
                        JSGSoundHelper.playSoundToPlayer((EntityPlayerMP)player, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.func_180425_c());
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.gate_busy", new Object[0]), true);
                    break;
                }
                case GATE_INFO: {
                    StargateUniverseBaseTile tile = (StargateUniverseBaseTile)world.func_175625_s(linkedPos);
                    if (tile == null) break;
                    switch (tile.getStargateState()) {
                        case IDLE: {
                            break block0;
                        }
                        case ENGAGED_INITIATING: {
                            tile.attemptClose(StargateClosedReasonEnum.REQUESTED);
                            break block0;
                        }
                        case ENGAGED: {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.dhd_block.incoming_wormhole_warn", new Object[0]), true);
                            break block0;
                        }
                    }
                    if (tile.getStargateState() == EnumStargateState.DIALING && tile.abortDialingSequence()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.aborting", new Object[0]), true);
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.gate_busy", new Object[0]), true);
                    break;
                }
                case RINGS: {
                    TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)world.func_175625_s(linkedPos);
                    if (ringsTile == null) break;
                    ringsTile.attemptTransportTo(new TransportRings(selectedCompound).getAddress(SymbolTypeTransportRingsEnum.GOAULD), 5).sendMessageIfFailed(player);
                    break;
                }
                case OC: {
                    ItemOCMessage message = new ItemOCMessage(selectedCompound);
                    JSG.debug("Sending OC message: " + message.toString());
                    JSG.ocWrapper.sendWirelessPacketPlayer("unv-dialer", player, player.func_184586_b(hand), message.address, message.port, message.getData());
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public void setCustomModelLocation() {
        ModelResourceLocation modelLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)modelLocation);
        CustomModelItemInterface.super.setCustomModelLocation();
        ModelBakery.registerItemVariants((Item)JSGItems.UNIVERSE_DIALER, (ResourceLocation[])new ResourceLocation[]{modelLocation});
        ModelLoader.setCustomMeshDefinition((Item)JSGItems.UNIVERSE_DIALER, stack -> modelLocation);
    }

    public static void broke(ItemStack stack) {
        if (stack.func_77973_b() == JSGItems.UNIVERSE_DIALER) {
            stack.func_77964_b(UniverseDialerVariants.BROKEN.meta);
            if (stack.func_77942_o()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static void setMemoryNameForIndex(NBTTagList list, int index, String name) {
        list.func_150305_b(index).func_74778_a("name", name);
    }

    public static void changeOCMessageAtIndex(NBTTagList list, int index, ChangeMessage changeMessage) {
        ItemOCMessage message = new ItemOCMessage(list.func_150305_b(index));
        changeMessage.change(message);
        list.func_150304_a(index, (NBTBase)message.serializeNBT());
    }

    public static interface ChangeMessage {
        public void change(ItemOCMessage var1);
    }

    public static enum UniverseDialerVariants implements EnumKeyInterface<Integer>
    {
        NORMAL(0, "universe_dialer"),
        BROKEN(1, "universe_dialer_broken");

        public final int meta;
        public final String name;
        private static final EnumKeyMap<Integer, UniverseDialerVariants> KEY_MAP;

        private UniverseDialerVariants(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        @Override
        public Integer getKey() {
            return this.meta;
        }

        public static UniverseDialerVariants valueOf(int id) {
            return KEY_MAP.valueOf(id);
        }

        static {
            KEY_MAP = new EnumKeyMap((EnumKeyInterface[])UniverseDialerVariants.values());
        }
    }
}

