/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.energy;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import tauri.dev.jsg.capability.ItemCapabilityProvider;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.power.stargate.StargateItemEnergyStorage;

public class CapacitorItemBlock
extends ItemBlock {
    public CapacitorItemBlock(Block block, boolean creative) {
        super(block);
        this.setRegistryName(creative ? "capacitor_block_creative" : "capacitor_block");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            StargateItemEnergyStorage energyStorage = (StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.setEnergyStored(energyStorage.getMaxEnergyStored());
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        String energy = String.format("%,d", energyStorage.getEnergyStored());
        String capacity = String.format("%,d", energyStorage.getMaxEnergyStored());
        tooltip.add(energy + " / " + capacity + " RF");
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored() * 100.0f)) + " %";
        tooltip.add(energyPercent);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, nbt, JSGConfig.Stargate.power.stargateEnergyStorage / 4);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return 1.0 - (double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored();
    }
}

