/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.integration.jei.category;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.integration.jei.AbstractJEIRecipe;

public class JEIChamberRecipeCategory
implements IRecipeCategory<AbstractJEIRecipe> {
    public static final String UID = "jsg_chamber";
    public static final ResourceLocation BACK_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_chamber_jei.png");
    public IDrawable background;
    public IDrawable icon;
    public IDrawable progressBar;
    public IDrawable fluidMeter;

    public JEIChamberRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACK_TEXTURE, 0, 0, 119, 55);
        this.fluidMeter = helper.createDrawable(BACK_TEXTURE, 176, 32, 16, 54);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((Block)JSGBlocks.MACHINE_CHAMBER));
        this.progressBar = helper.createAnimatedDrawable(helper.createDrawable(BACK_TEXTURE, 176, 0, 40, 15), 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"tile.jsg.crystal_chamber_block.name", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Just Stargate Mod";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.fluidMeter.draw(minecraft, 46, 0);
        this.progressBar.draw(minecraft, 40, 19);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AbstractJEIRecipe crystalChamberRecipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 18);
        recipeLayout.getItemStacks().init(1, false, 98, 18);
        recipeLayout.getItemStacks().set(ingredients);
        recipeLayout.getFluidStacks().init(2, true, 47, 1, 16, 53, 7000, false, this.fluidMeter);
        recipeLayout.getFluidStacks().set(2, crystalChamberRecipe.getSubFluidStack());
    }
}

