/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.integration;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.machine.Machine;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.network.WirelessEndpoint;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import tauri.dev.jsg.capability.endpoint.ItemEndpointCapability;
import tauri.dev.jsg.capability.endpoint.ItemEndpointInterface;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.integration.OCWrapperInterface;
import tauri.dev.jsg.item.oc.ItemWirelessEndpoint;

public class OCWrapperLoaded
implements OCWrapperInterface {
    @Override
    public void sendSignalToReachable(Node node, Context invoker, String name, Object ... params) {
        if (node == null) {
            return;
        }
        for (Node targetNode : node.reachableNodes()) {
            if (!(targetNode.host() instanceof Machine)) continue;
            Machine machine = (Machine)targetNode.host();
            boolean caller = machine == invoker;
            Object[] array = new Object[params.length + 2];
            array[0] = node.address();
            array[1] = caller;
            for (int i = 0; i < params.length; ++i) {
                array[i + 2] = params[i];
            }
            machine.signal(name, array);
        }
    }

    @Override
    public Node createNode(TileEntity environment, String componentName) {
        return Network.newNode((Environment)((Environment)environment), (Visibility)Visibility.Network).withComponent(componentName, Visibility.Network).create();
    }

    @Override
    public void joinOrCreateNetwork(TileEntity tileEntity) {
        Network.joinOrCreateNetwork((TileEntity)tileEntity);
    }

    @Override
    public boolean isModLoaded() {
        return true;
    }

    @Override
    public void sendWirelessPacketPlayer(String packetPrefix, EntityPlayer player, ItemStack stack, String address, short port, Object[] data) {
        ItemEndpointInterface endpointStack = (ItemEndpointInterface)stack.getCapability(ItemEndpointCapability.ENDPOINT_CAPABILITY, null);
        if (endpointStack.hasEndpoint()) {
            endpointStack.resetEndpointCounter(player.func_130014_f_().func_82737_E());
        } else {
            ItemWirelessEndpoint endpoint = new ItemWirelessEndpoint(player);
            Network.joinWirelessNetwork((WirelessEndpoint)endpoint);
            endpointStack.setEndpoint(endpoint, player.func_130014_f_().func_82737_E());
        }
        if (address.isEmpty()) {
            address = null;
        }
        Packet packet = Network.newPacket((String)(packetPrefix + "-" + player.func_70005_c_()), (String)address, (int)port, (Object[])data);
        Network.sendWirelessPacket((WirelessEndpoint)((WirelessEndpoint)endpointStack.getEndpoint()), (double)JSGConfig.General.integration.ocIntegrationWirelessRange, (Packet)packet);
    }

    @Override
    public void joinWirelessNetwork(Object endpoint) {
        Network.joinWirelessNetwork((WirelessEndpoint)((WirelessEndpoint)endpoint));
    }

    @Override
    public void leaveWirelessNetwork(Object endpoint) {
        Network.leaveWirelessNetwork((WirelessEndpoint)((WirelessEndpoint)endpoint));
    }

    @Override
    public void updateWirelessNetwork(Object endpoint) {
        Network.updateWirelessNetwork((WirelessEndpoint)((WirelessEndpoint)endpoint));
    }
}

