/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.mainmenu;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.gui.mainmenu.GuiCustomMainMenu;

@SideOnly(value=Side.CLIENT)
public class MainMenuNotifications {
    public static final MainMenuNotifications INSTANCE = new MainMenuNotifications();
    private static final ResourceLocation NOTIFICATION_TEXTURE = new ResourceLocation("jsg", "textures/gui/mainmenu/popup.png");
    public static final int BUTTONS_ID_START = 40;
    private final HashMap<Integer, Notification> NOTIFICATIONS = new HashMap();
    private int id = 0;
    public Notification currentDisplayed = this.getFirstToDisplay();
    public int width = 0;
    public int height = 0;
    public Minecraft mc = Minecraft.func_71410_x();
    public static final int BACKGROUND_WIDTH = 300;
    public static final int BACKGROUND_HEIGHT = 140;

    public static MainMenuNotifications getManager() {
        return INSTANCE;
    }

    public int getId() {
        return this.id;
    }

    public int add(Notification notification) {
        this.NOTIFICATIONS.put(this.getId(), notification);
        return this.id++;
    }

    @Nullable
    public Notification get(int id) {
        return this.NOTIFICATIONS.get(id);
    }

    @Nullable
    public Notification getFirstToDisplay() {
        for (Notification n : this.NOTIFICATIONS.values()) {
            if (n.dismissed) continue;
            return n;
        }
        return null;
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return new int[]{(this.width - rectWidth) / 2, (this.height - rectHeight) / 2};
    }

    public void update() {
        this.currentDisplayed = this.getFirstToDisplay();
    }

    public void render(int mouseX, int mouseY, int winWidth, int winHeight, GuiScreen parentScreen) {
        this.width = winWidth;
        this.height = winHeight;
        if (this.currentDisplayed == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int[] center = this.getCenterPos(300, 140);
        int x = center[0];
        int y = center[1];
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NOTIFICATION_TEXTURE);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)300, (int)140, (float)300.0f, (float)140.0f);
        this.currentDisplayed.render(mouseX, mouseY, this.width, this.height, x, y, parentScreen);
        GlStateManager.func_179121_F();
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.currentDisplayed == null) {
            return;
        }
        if (mouseButton != 0) {
            return;
        }
        for (GuiButton guibutton : this.currentDisplayed.buttons) {
            if (!guibutton.func_146116_c(this.mc, mouseX, mouseY)) continue;
            guibutton.func_146113_a(this.mc.func_147118_V());
            this.currentDisplayed.actionPerformed(guibutton);
        }
    }

    public static class Notification {
        public boolean dismissed;
        public final String[] lines;
        public final List<GuiButton> buttons;

        public Notification(List<GuiButton> buttons, String ... text) {
            this.lines = text;
            this.buttons = buttons;
            this.dismissed = false;
        }

        public void dismiss() {
            this.dismissed = true;
        }

        public void actionPerformed(@Nonnull GuiButton button) {
        }

        public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, GuiScreen parentScreen) {
            this.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
        }

        public void renderText(int mouseX, int mouseY, int width, int height, int rectX, int rectY, GuiScreen parentScreen) {
            int centerX = MainMenuNotifications.getManager().getCenterPos(0, 0)[0];
            int i = 0;
            for (String s : this.lines) {
                if (parentScreen instanceof GuiCustomMainMenu) {
                    ((GuiCustomMainMenu)parentScreen).drawCenteredString(parentScreen.field_146297_k.field_71466_p, s, centerX, rectY + 18 + 10 * i, 0x404040, false);
                } else {
                    parentScreen.field_146297_k.field_71466_p.func_78276_b(s, centerX - parentScreen.field_146297_k.field_71466_p.func_78256_a(s) / 2, rectY + 18 + 10 * i, 0x404040);
                }
                ++i;
            }
        }
    }
}

