/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.mainmenu;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.model.ModelLoader;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.ChevronTextureList;
import tauri.dev.jsg.renderer.stargate.StargateMilkyWayRenderer;
import tauri.dev.jsg.stargate.StargateClassicSpinHelper;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.util.math.NumberUtils;

public enum EnumMainMenuGateType {
    MILKYWAY,
    UNIVERSE,
    PEGASUS;


    public static EnumMainMenuGateType random(@Nullable EnumMainMenuGateType previousType) {
        EnumMainMenuGateType newType;
        do {
            int i = new Random().nextInt(3);
            switch (i) {
                default: {
                    newType = MILKYWAY;
                    break;
                }
                case 1: {
                    newType = PEGASUS;
                    break;
                }
                case 2: {
                    newType = UNIVERSE;
                }
            }
        } while (newType == previousType);
        return newType;
    }

    public void renderGate(int x, int y, float size, double tick) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)size, (float)(-size), (float)size);
        GlStateManager.func_179101_C();
        switch (this) {
            default: {
                break;
            }
            case MILKYWAY: {
                this.renderMWGate(tick);
                break;
            }
            case PEGASUS: {
                this.renderPEGGate(tick);
                break;
            }
            case UNIVERSE: {
                this.renderUNIGate(tick);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
    }

    private void renderMWGate(double tick) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)StargateMilkyWayRenderer.RING_LOC.field_72450_a, (double)StargateMilkyWayRenderer.RING_LOC.field_72449_c, (double)StargateMilkyWayRenderer.RING_LOC.field_72448_b);
        GlStateManager.func_179114_b((float)((float)(-(tick * (double)(StargateClassicSpinHelper.A_ANGLE_PER_TICK / 2.0f)) % 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-StargateMilkyWayRenderer.RING_LOC.field_72450_a), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72449_c), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72448_b));
        ElementEnum.MILKYWAY_RING.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        ModelLoader.getModel(((SymbolMilkyWayEnum)SymbolMilkyWayEnum.getOrigin()).getModelResource(BiomeOverlayEnum.NORMAL, 0, false, false, 5)).render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        ChevronTextureList chevrons = new ChevronTextureList("milkyway/chevron", 7, true);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                if (light) {
                    float color = chevrons.getColor(chevron);
                    GlStateManager.func_179124_c((float)color, (float)color, (float)color);
                } else {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevron, light)).bindTexture();
                ElementEnum.MILKYWAY_CHEVRON_MOVING.render();
                ElementEnum.MILKYWAY_CHEVRON_LIGHT.render();
                if (!light) {
                    ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
                    ElementEnum.MILKYWAY_CHEVRON_BACK.render();
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        ElementEnum.MILKYWAY_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        GlStateManager.func_179121_F();
    }

    private void renderUNIGate(double tick) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.14f, (float)1.14f, (float)1.14f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)((float)(-(tick * (double)(StargateClassicSpinHelper.A_ANGLE_PER_TICK / 2.0f)) % 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        ElementEnum.UNIVERSE_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        ChevronTextureList chevrons = new ChevronTextureList("universe/universe_chevron", 9, true);
        chevrons.initClient();
        for (ChevronEnum chevronEnum : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)chevronEnum.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                if (light) {
                    float color = chevrons.getColor(chevronEnum);
                    GlStateManager.func_179124_c((float)color, (float)color, (float)color);
                } else {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevronEnum, light)).bindTexture();
                ElementEnum.UNIVERSE_CHEVRON.render();
                GlStateManager.func_179121_F();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179121_F();
        ElementEnum.UNIVERSE_SYMBOL.bindTexture(BiomeOverlayEnum.NORMAL);
        for (Enum enum_ : SymbolUniverseEnum.values()) {
            if (((SymbolUniverseEnum)enum_).modelResource == null) continue;
            float color = 0.25f;
            switch (1.$SwitchMap$tauri$dev$jsg$stargate$network$SymbolUniverseEnum[enum_.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    color += 0.6f;
                    break;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
            ModelLoader.getModel(((SymbolUniverseEnum)enum_).modelResource).render();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void renderPEGGate(double tick) {
        GlStateManager.func_179094_E();
        ElementEnum.PEGASUS_RING.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        ElementEnum.PEGASUS_GATE.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        int glyphsCount = (int)(tick / 2.0 % 111.0);
        if (glyphsCount > 36) {
            glyphsCount = 36;
        }
        int chevronsCount = glyphsCount / 4;
        for (int i = -8; i < glyphsCount - 8; ++i) {
            int ii = i % 36;
            if (ii < 0) {
                ii = 36 + ii;
            }
            ii = 36 - ii;
            this.renderPegasusGlyph(ii, ii);
        }
        GlStateManager.func_179121_F();
        if (chevronsCount == 4) {
            chevronsCount = 3;
        }
        if (chevronsCount == 5) {
            chevronsCount = 3;
        }
        if (chevronsCount > 5) {
            chevronsCount -= 2;
        }
        GlStateManager.func_179094_E();
        ChevronTextureList chevrons = new ChevronTextureList("pegasus/chevron", chevronsCount, chevronsCount == 7);
        chevrons.initClient();
        for (ChevronEnum chevron : ChevronEnum.values()) {
            for (int i = 0; i < 2; ++i) {
                boolean light = i == 1;
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                if (light) {
                    float color = chevrons.getColor(chevron);
                    GlStateManager.func_179124_c((float)color, (float)color, (float)color);
                } else {
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
                TextureLoader.getTexture(chevrons.get(BiomeOverlayEnum.NORMAL, chevron, light)).bindTexture();
                ElementEnum.PEGASUS_CHEVRON_MOVING.render();
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render();
                if (!light) {
                    ElementEnum.PEGASUS_CHEVRON_FRAME.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
                    ElementEnum.PEGASUS_CHEVRON_BACK.render();
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179121_F();
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    private void renderPegasusGlyph(int glyphId, int slot) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
        GlStateManager.func_179137_b((double)NumberUtils.round(slotPos[0], 3), (double)NumberUtils.round(slotPos[1], 3), (double)0.205);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        String path = String.format("pegasus/%s.png", "glyphs");
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLoader.getTextureResource(path));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double radius = 0.94;
        int textureSlot = SymbolPegasusEnum.valueOf((int)glyphId).textureSlot;
        double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
        double x = (uv[0] + radius) / 2.0;
        double y = (uv[1] + radius) / 2.0;
        double tileSize = 0.27;
        double uvSize = 0.0625;
        GlStateManager.func_179114_b((float)(10.0f * (float)(slot - textureSlot)), (float)0.0f, (float)1.0f, (float)0.0f);
        buffer.func_181662_b(-tileSize, 0.0, -tileSize).func_187315_a(x, y).func_181675_d();
        buffer.func_181662_b(-tileSize, 0.0, tileSize).func_187315_a(x, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, tileSize).func_187315_a(x + uvSize, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, -tileSize).func_187315_a(x + uvSize, y).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179121_F();
    }
}

