/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.gui.base.JSGButton;
import tauri.dev.jsg.gui.element.ArrowButton;
import tauri.dev.jsg.gui.entry.AbstractAddressEntryChangeGui;
import tauri.dev.jsg.gui.entry.OCEntryChangeGui;
import tauri.dev.jsg.gui.entry.Section;
import tauri.dev.jsg.gui.entry.UniverseEntry;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerActionEnum;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerActionPacketToServer;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerMode;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;

public class UniverseEntryChangeGui
extends AbstractAddressEntryChangeGui {
    private World world;
    protected GuiButton ocButton = null;
    protected GuiButton abortButton = null;

    public UniverseEntryChangeGui(EnumHand hand, NBTTagCompound compound, World world) {
        super(hand, compound);
        this.world = world;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (JSG.ocWrapper.isModLoaded()) {
            this.ocButton = new ArrowButton(100, 0, 0, ArrowButton.ArrowType.RIGHT).setFgColor(GuiUtils.getColorCode((char)'a', (boolean)true)).setActionCallback(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new OCEntryChangeGui(this.hand, this.mainCompound, this)));
            this.field_146292_n.add(this.ocButton);
        }
        this.abortButton = new JSGButton(100, 0, 0, 50, 20, new TextComponentTranslation("item.jsg.universe_dialer.abort", new Object[0]).func_150254_d()).setFgColor(GuiUtils.getColorCode((char)'c', (boolean)true)).setActionCallback(() -> JSGPacketHandler.INSTANCE.sendToServer((IMessage)new UniverseDialerActionPacketToServer(UniverseDialerActionEnum.ABORT, this.hand, false)));
        this.field_146292_n.add(this.abortButton);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.ocButton != null) {
            this.ocButton.field_146128_h = this.dispx + this.guiWidth + 3;
            this.ocButton.field_146129_i = this.field_146295_m - 25 - 3 - 20;
        }
        if (this.abortButton != null) {
            this.abortButton.field_146125_m = this.mainCompound.func_74764_b("linkedGate");
            this.abortButton.field_146128_h = this.dispx - 25 + 2;
            this.abortButton.field_146129_i = this.field_146295_m - 25 - 3 - 20;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void generateEntries() {
        NBTTagList list = this.mainCompound.func_150295_c(UniverseDialerMode.MEMORY.tagListName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            StargateAddress stargateAddress = new StargateAddress(compound);
            int maxSymbols = SymbolUniverseEnum.getMaxSymbolsDisplay(compound.func_74767_n("hasUpgrade"));
            String name = "";
            if (compound.func_74764_b("name")) {
                name = compound.func_74779_i("name");
            }
            UniverseEntry entry = new UniverseEntry(this.field_146297_k, i, list.func_74745_c(), this.hand, name, (action, index) -> this.performAction(action, index), SymbolTypeEnum.UNIVERSE, stargateAddress, maxSymbols);
            this.entries.add(entry);
        }
    }

    @Override
    protected void generateSections() {
        this.sections.add(new Section(80, "item.jsg.gui.address"));
        this.sections.add(new Section(100, "item.jsg.gui.name"));
        this.sections.add(new Section(95, ""));
    }

    @Override
    protected int getEntryBottomMargin() {
        return 2;
    }

    @Override
    public int getAddressWidth() {
        return 80;
    }
}

