/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHand;
import tauri.dev.jsg.gui.entry.AbstractAddressEntry;
import tauri.dev.jsg.gui.entry.AbstractEntry;
import tauri.dev.jsg.packet.gui.entry.EntryDataTypeEnum;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public class NotebookEntry
extends AbstractAddressEntry {
    public static final int ADDRESS_WIDTH = 160;
    public static final int BUTTON_COUNT = 3;

    public NotebookEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, String name, AbstractEntry.ActionListener reloadListener, SymbolTypeEnum type, SymbolTypeTransportRingsEnum ringsType, StargateAddress addr, TransportRingsAddress ringsAddr, int maxSymbols) {
        super(mc, index, maxIndex, hand, name, reloadListener, type, ringsType, addr, ringsAddr, maxSymbols);
    }

    @Override
    public void renderAt(int dx, int dy, int mouseX, int mouseY, float partialTicks) {
        int size = 20;
        int sizeX = 20;
        if (this.stargateAddress != null && this.stargateAddress.getSymbolType() == SymbolTypeEnum.UNIVERSE) {
            sizeX /= 2;
        }
        if (this.ringsAddress != null && this.ringsAddress.getSymbolType() == SymbolTypeTransportRingsEnum.ANCIENT) {
            sizeX /= 2;
        }
        int x = dx + (160 - sizeX * this.maxSymbols) / 2;
        for (int i = 0; i < this.maxSymbols; ++i) {
            SymbolInterface symbol = null;
            if (this.stargateAddress != null) {
                symbol = this.stargateAddress.get(i);
            } else if (this.ringsAddress != null) {
                symbol = this.ringsAddress.get(i);
            }
            if (symbol != null) {
                this.renderSymbol(x, dy, sizeX, 20, mouseX, mouseY, symbol);
            }
            x += sizeX;
        }
        super.renderAt(dx + 160 + 10, dy, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getHeight() {
        return 20;
    }

    @Override
    protected int getMaxNameLength() {
        return 11;
    }

    @Override
    protected EntryDataTypeEnum getEntryDataType() {
        return EntryDataTypeEnum.PAGE;
    }
}

