/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import tauri.dev.jsg.gui.base.JSGButton;
import tauri.dev.jsg.gui.entry.AbstractEntry;
import tauri.dev.jsg.gui.entry.Section;
import tauri.dev.jsg.packet.gui.entry.EntryActionEnum;

public abstract class AbstractEntryChangeGui
extends GuiScreen {
    public static final int PADDING = 25;
    protected EnumHand hand;
    protected NBTTagCompound mainCompound;
    protected List<AbstractEntry> entries = new ArrayList<AbstractEntry>();
    protected List<Section> sections = new ArrayList<Section>();
    protected int dispx;
    protected int guiWidth;
    protected int guiHeight;
    protected int scrolledHeight = 0;
    protected boolean firstRun = true;

    public AbstractEntryChangeGui(EnumHand hand, NBTTagCompound compound) {
        this.hand = hand;
        this.mainCompound = compound;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        if (this.firstRun) {
            this.firstRun = false;
            this.entries.clear();
            this.generateEntries();
            this.sections.clear();
            this.generateSections();
            this.guiWidth = 0;
            for (Section section : this.sections) {
                this.guiWidth += section.getWidth() + 10;
            }
            this.guiWidth -= 10;
            this.calculateGuiHeight();
        }
        this.dispx = (this.field_146294_l - this.guiWidth) / 2;
    }

    protected void calculateGuiHeight() {
        this.guiHeight = 14;
        for (AbstractEntry entry : this.entries) {
            this.guiHeight += entry.getHeight() + this.getEntryBottomMargin();
        }
        this.guiHeight -= this.getEntryBottomMargin();
        if (this.guiHeight > this.field_146295_m - 14) {
            this.guiHeight = this.field_146295_m - 14;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_73733_a(this.dispx - 25, 25, this.dispx + 25 + this.guiWidth, this.field_146295_m - 25, -1072689136, -804253680);
        int y = 50 + this.scrolledHeight;
        for (AbstractEntry entry : this.entries) {
            if (y > 27 && y + entry.getHeight() + this.getEntryBottomMargin() < this.field_146295_m - 25) {
                entry.renderAt(this.dispx, y, mouseX, mouseY, partialTicks);
            } else {
                entry.setLocation(this.dispx, y);
            }
            y += entry.getHeight() + this.getEntryBottomMargin();
        }
        this.func_73733_a(this.dispx - 25, 25, this.dispx + 25 + this.guiWidth, 45, -1072689136, -804253680);
        this.func_73733_a(this.dispx - 25, this.field_146295_m - 25 - 20 - 6, this.dispx + 25 + this.guiWidth, this.field_146295_m - 25, -1072689136, -804253680);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int x = this.dispx;
        for (Section section : this.sections) {
            section.render(this.field_146289_q, x, 30);
            x += section.getWidth() + 10;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        for (AbstractEntry entry : this.entries) {
            for (GuiTextField tf : entry.textFields) {
                tf.func_146195_b(false);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i2 = Mouse.getEventDWheel();
        if (i2 != 0) {
            i2 = i2 > 0 ? 1 : -1;
            if (this.entries.size() < 1) {
                return;
            }
            int entryHeightComplete = 0;
            for (AbstractEntry entry : this.entries) {
                entryHeightComplete += entry.getHeight() + this.getEntryBottomMargin();
            }
            if (this.scrolledHeight >= 0 && i2 == 1) {
                return;
            }
            if (this.scrolledHeight - 3 * this.entries.get(0).getHeight() <= -1 * entryHeightComplete && i2 == -1) {
                return;
            }
            this.scrolledHeight = (int)((float)this.scrolledHeight + (float)(i2 * 15 / 2));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (AbstractEntry entry : this.entries) {
            if (entry.mouseClicked(mouseX, mouseY, mouseButton)) break;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (AbstractEntry entry : this.entries) {
            entry.keyTyped(typedChar, keyCode);
        }
        boolean shift = Keyboard.isKeyDown((int)42);
        if (keyCode == 15) {
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get((int)i).nameField.func_146206_l()) continue;
                if (shift) {
                    if (i == 0) break;
                    this.entries.get((int)i).nameField.func_146195_b(false);
                    this.entries.get((int)(i - 1)).nameField.func_146195_b(true);
                    break;
                }
                if (i == this.entries.size() - 1) break;
                this.entries.get((int)i).nameField.func_146195_b(false);
                this.entries.get((int)(i + 1)).nameField.func_146195_b(true);
                break;
            }
        }
    }

    public void func_73876_c() {
        for (AbstractEntry entry : this.entries) {
            entry.updateScreen();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void performAction(EntryActionEnum action, int index) {
        switch (action) {
            case MOVE_UP: {
                this.entriesSwitchPlaces(index, index - 1);
                break;
            }
            case MOVE_DOWN: {
                this.entriesSwitchPlaces(index, index + 1);
                break;
            }
            case REMOVE: {
                this.entries.remove(index);
                if (this.entries.size() == 0) {
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                    if (this.field_146297_k.field_71462_r == null) {
                        this.field_146297_k.func_71381_h();
                    }
                }
                for (int i = index; i < this.entries.size(); ++i) {
                    this.entries.get((int)i).index = i;
                }
                this.calculateGuiHeight();
                break;
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        ((JSGButton)button).performAction();
    }

    private void entriesSwitchPlaces(int a, int b) {
        AbstractEntry entry = this.entries.get(a);
        this.entries.set(a, this.entries.get(b));
        this.entries.set(b, entry);
        this.entries.get((int)a).index = a;
        this.entries.get((int)b).index = b;
    }

    protected abstract void generateEntries();

    protected abstract void generateSections();

    protected abstract int getEntryBottomMargin();
}

