/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.entry.AbstractAddressEntry;
import tauri.dev.jsg.gui.entry.AbstractEntry;
import tauri.dev.jsg.gui.entry.AbstractEntryChangeGui;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.transportrings.TransportRingsAddress;

public abstract class AbstractAddressEntryChangeGui
extends AbstractEntryChangeGui {
    public AbstractAddressEntryChangeGui(EnumHand hand, NBTTagCompound compound) {
        super(hand, compound);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        AbstractEntry entry;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext() && (entry = (AbstractEntry)iterator.next()) instanceof AbstractAddressEntry) {
            AbstractAddressEntry e = (AbstractAddressEntry)entry;
            int maxSymbols = e.getMaxSymbols();
            int dy = e.entryY;
            if (!GuiHelper.isPointInRegion(this.dispx, dy, this.getAddressWidth(), e.getHeight(), mouseX, mouseY)) continue;
            ArrayList<String> text = new ArrayList<String>();
            StargateAddress stargateAddress = e.getStargateAddress();
            TransportRingsAddress ringsAddress = e.getRingsAddress();
            for (int i = 0; i < maxSymbols; ++i) {
                SymbolInterface symbol = null;
                if (stargateAddress != null) {
                    symbol = stargateAddress.get(i);
                } else if (ringsAddress != null) {
                    symbol = ringsAddress.get(i);
                }
                if (symbol == null) continue;
                text.add(symbol.getEnglishName());
            }
            this.func_146283_a(text, mouseX + 5, mouseY);
        }
    }

    public abstract int getAddressWidth();
}

