/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element.tabs;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;

public class TabTRAddress
extends Tab {
    private final TransportRingsAbstractTile trTile;
    private final SymbolTypeTransportRingsEnum symbolType;
    private final int progressColor;

    protected TabTRAddress(TabAddressBuilder builder) {
        super(builder);
        this.trTile = builder.trTile;
        this.symbolType = builder.symbolType;
        this.progressColor = builder.progressColor;
    }

    public static TabAddressBuilder builder() {
        return new TabAddressBuilder();
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.trTile.getRings().getAddress(this.symbolType) != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 105), (int)(this.guiTop + this.defaultY + 86), (float)6.0f, (float)179.0f, (int)18, (int)18, (float)this.textureSize, (float)this.textureSize);
            int shadow = 2;
            float color = 1.0f;
            for (int i = 0; i < 4; ++i) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.trTile.getRings().getAddress(this.symbolType).get(i).getIconResource(BiomeOverlayEnum.NORMAL, 0));
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                GuiHelper.drawTexturedRectWithShadow(symbolCoords.x, symbolCoords.y, shadow, shadow, this.symbolType.iconWidth, this.symbolType.iconHeight, color);
            }
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
            short progress = this.trTile.getPageProgress();
            Color c = new Color(this.progressColor);
            float red = c.getRed();
            float green = c.getGreen();
            float blue = c.getBlue();
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 97), (int)(this.guiTop + this.defaultY + 86 + (18 - progress)), (float)0.0f, (float)(179 + (18 - progress)), (int)6, (int)progress, (float)this.textureSize, (float)this.textureSize);
            GlStateManager.func_179084_k();
        }
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && this.trTile.getRings().getAddress(this.symbolType) != null) {
            for (int i = 0; i < 4; ++i) {
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                if (!GuiHelper.isPointInRegion(symbolCoords.x, symbolCoords.y, this.symbolType.iconWidth, this.symbolType.iconHeight, mouseX, mouseY)) continue;
                screen.func_146279_a(this.trTile.getRings().getAddress(this.symbolType).get(i).localize(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    public Tab.SlotTab createSlot(SlotItemHandler slot) {
        return new Tab.SlotTab(slot, slotTab -> {
            slotTab.field_75223_e = this.currentOffsetX + 106;
            slotTab.field_75221_f = this.defaultY + 87;
        });
    }

    public SymbolCoords getSymbolCoords(int symbol) {
        if (this.symbolType == SymbolTypeTransportRingsEnum.ANCIENT) {
            return new SymbolCoords(this.guiLeft + this.currentOffsetX + 24 + 16 * (symbol % 6), this.guiTop + this.defaultY + 20 + 45 * (symbol / 6));
        }
        return new SymbolCoords(this.guiLeft + this.currentOffsetX + 29 + 31 * (symbol % 3), this.guiTop + this.defaultY + 20 + 28 * (symbol / 3));
    }

    public static class TabAddressBuilder
    extends Tab.TabBuilder {
        private TransportRingsAbstractTile trTile;
        private SymbolTypeTransportRingsEnum symbolType;
        private int progressColor;

        public TabAddressBuilder setTile(TransportRingsAbstractTile gateTile) {
            this.trTile = gateTile;
            return this;
        }

        public TabAddressBuilder setSymbolType(SymbolTypeTransportRingsEnum symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public TabAddressBuilder setProgressColor(int color) {
            this.progressColor = color;
            return this;
        }

        @Override
        public TabTRAddress build() {
            return new TabTRAddress(this);
        }
    }

    public static class SymbolCoords {
        public final int x;
        public final int y;

        public SymbolCoords(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

