/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element.tabs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.beamer.BeamerModeEnum;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.packet.BeamerChangedInactivityToServer;
import tauri.dev.jsg.packet.BeamerChangedLevelsToServer;
import tauri.dev.jsg.packet.ChangeRedstoneModeToServer;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.tileentity.util.RedstoneModeEnum;

public class TabRedstone
extends Tab {
    private final List<LabeledTextBox> textBoxes = new ArrayList<LabeledTextBox>();
    private final RedstoneModeGetter modeGetter;
    private final BeamerModeGetter beamerModeGetter;
    private final BlockPos pos;
    private final GuiButton saveButton;
    private boolean invalid;

    protected TabRedstone(TabRedstoneBuilder builder) {
        super(builder);
        this.modeGetter = builder.modeGetter;
        this.beamerModeGetter = builder.beamerModeGetter;
        this.pos = builder.pos;
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52, builder.fontRenderer, "gui.beamer.activate_below"));
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52 + 33, builder.fontRenderer, "gui.beamer.deactivate_over"));
        this.textBoxes.add(new LabeledTextBox(0, this.defaultY + 52, builder.fontRenderer, "gui.beamer.deactivate", "gui.beamer.after_inactivity"));
        this.saveButton = new GuiButton(0, 0, this.guiTop + this.defaultY + 102, 35, 20, I18n.func_135052_a((String)"gui.beamer.save", (Object[])new Object[0]));
    }

    public void setText(int index, int number) {
        this.textBoxes.get(index).setText(number);
    }

    private List<LabeledTextBox> getTextBoxes(BeamerModeEnum beamerMode) {
        if (beamerMode == BeamerModeEnum.ITEMS) {
            return this.textBoxes.subList(2, 3);
        }
        if (beamerMode != BeamerModeEnum.NONE) {
            return this.textBoxes.subList(0, 2);
        }
        return new ArrayList<LabeledTextBox>();
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(this.bgTexLocation);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RedstoneModeEnum currentMode = this.modeGetter.get();
        for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
            RedstoneModeEnum redstoneMode = RedstoneModeEnum.values()[i];
            ButtonXY b = this.getButtonXY(i);
            boolean active = redstoneMode == currentMode;
            int yTex = (active |= GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) ? 231 : 211;
            Gui.func_146110_a((int)b.x, (int)b.y, (float)128.0f, (float)yTex, (int)20, (int)20, (float)this.textureSize, (float)this.textureSize);
            Gui.func_146110_a((int)b.x, (int)b.y, (float)(148 + 20 * i), (float)211.0f, (int)20, (int)20, (float)this.textureSize, (float)this.textureSize);
        }
        if (currentMode == RedstoneModeEnum.AUTO) {
            for (LabeledTextBox textBox : this.getTextBoxes(this.beamerModeGetter.get())) {
                textBox.draw();
            }
            this.saveButton.field_146128_h = this.guiLeft + this.currentOffsetX + 90;
            this.saveButton.func_191745_a(mc, mouseX, mouseY, 0.0f);
            int y = this.guiTop + this.defaultY + 68;
            if (this.beamerModeGetter.get() == BeamerModeEnum.ITEMS) {
                y += 10;
            }
            if (this.invalid) {
                fontRenderer.func_78276_b(TextFormatting.DARK_RED + I18n.func_135052_a((String)"gui.beamer.invalid", (Object[])new Object[0]), this.guiLeft + this.currentOffsetX + 90, y, 0xFFFFFF);
            }
        }
        GlStateManager.func_179084_k();
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        if (this.isOpen()) {
            for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
                ButtonXY b = this.getButtonXY(i);
                if (!GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) continue;
                RedstoneModeEnum mode = RedstoneModeEnum.valueOf(i);
                String text = I18n.func_135052_a((String)mode.translationKey, (Object[])new Object[0]);
                if (mode == RedstoneModeEnum.IGNORED && JSG.ocWrapper.isModLoaded()) {
                    text = text + " (OpenComputers)";
                }
                screen.func_146279_a(text, mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
    }

    private ButtonXY getButtonXY(int i) {
        int x = this.guiLeft + this.currentOffsetX + 33 + 23 * i;
        int y = this.guiTop + this.defaultY + 23;
        return new ButtonXY(x, y);
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        boolean typed = false;
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            if (!tf.textField.func_146201_a(typedChar, keyCode)) continue;
            typed = true;
        }
        return typed;
    }

    @Override
    public void updateScreen() {
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            tf.textField.func_146178_a();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.isOpen()) {
            return;
        }
        RedstoneModeEnum currentMode = this.modeGetter.get();
        for (LabeledTextBox tf : this.getTextBoxes(this.beamerModeGetter.get())) {
            tf.textField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        for (int i = 0; i < RedstoneModeEnum.values().length; ++i) {
            ButtonXY b = this.getButtonXY(i);
            if (!GuiHelper.isPointInRegion(b.x, b.y, 20, 20, mouseX, mouseY)) continue;
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new ChangeRedstoneModeToServer(this.pos, RedstoneModeEnum.valueOf(i)));
            break;
        }
        if (currentMode == RedstoneModeEnum.AUTO && this.saveButton.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            switch (this.beamerModeGetter.get()) {
                case POWER: 
                case FLUID: {
                    try {
                        int start = Integer.parseInt(this.textBoxes.get(0).textField.func_146179_b());
                        int stop = Integer.parseInt(this.textBoxes.get(1).textField.func_146179_b());
                        if (start < 0 || stop > 100 || start >= stop) {
                            throw new NumberFormatException();
                        }
                        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new BeamerChangedLevelsToServer(this.pos, start, stop));
                        this.invalid = false;
                    }
                    catch (NumberFormatException e) {
                        this.invalid = true;
                    }
                    break;
                }
                case ITEMS: {
                    try {
                        int inactivity = Integer.parseInt(this.textBoxes.get(2).textField.func_146179_b());
                        if (inactivity < 0) {
                            throw new NumberFormatException();
                        }
                        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new BeamerChangedInactivityToServer(this.pos, inactivity));
                        this.invalid = false;
                    }
                    catch (NumberFormatException e) {
                        this.invalid = true;
                    }
                    break;
                }
            }
        }
    }

    public static TabRedstoneBuilder builder() {
        return new TabRedstoneBuilder();
    }

    public static interface BeamerModeGetter {
        public BeamerModeEnum get();
    }

    public static interface RedstoneModeGetter {
        public RedstoneModeEnum get();
    }

    public static class TabRedstoneBuilder
    extends Tab.TabBuilder {
        private FontRenderer fontRenderer;
        private RedstoneModeGetter modeGetter;
        private BeamerModeGetter beamerModeGetter;
        private BlockPos pos;

        public TabRedstoneBuilder setFontRenderer(FontRenderer fontRenderer) {
            this.fontRenderer = fontRenderer;
            return this;
        }

        public TabRedstoneBuilder setRedstoneModeGetter(RedstoneModeGetter modeGetter) {
            this.modeGetter = modeGetter;
            return this;
        }

        public TabRedstoneBuilder setBeamerModeGetter(BeamerModeGetter beamerModeGetter) {
            this.beamerModeGetter = beamerModeGetter;
            return this;
        }

        public TabRedstoneBuilder setBlockPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public TabRedstone build() {
            return new TabRedstone(this);
        }
    }

    private class LabeledTextBox {
        private final int y;
        private final List<String> text;
        private final GuiTextField textField;
        private final FontRenderer fontRenderer;

        public LabeledTextBox(int id, int y, FontRenderer fontRenderer, String ... translationKey) {
            this.y = TabRedstone.this.guiTop + y;
            this.fontRenderer = fontRenderer;
            this.text = new ArrayList<String>();
            for (String tr : translationKey) {
                this.text.add(I18n.func_135052_a((String)tr, (Object[])new Object[0]));
            }
            this.textField = new GuiTextField(id, fontRenderer, 0, this.y + 11 * translationKey.length, 50, 16);
        }

        public LabeledTextBox setText(int number) {
            this.textField.func_146180_a("" + number);
            return this;
        }

        public void draw() {
            this.textField.field_146209_f = TabRedstone.this.guiLeft + TabRedstone.this.currentOffsetX + 31;
            int y = this.y;
            for (String text : this.text) {
                this.fontRenderer.func_78276_b(text, TabRedstone.this.guiLeft + TabRedstone.this.currentOffsetX + 29, y, 0x404040);
                y += 11;
            }
            this.textField.func_146194_f();
        }
    }

    private static class ButtonXY {
        public final int x;
        public final int y;

        public ButtonXY(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

