/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidTank;
import tauri.dev.jsg.gui.element.GuiHelper;

public class FluidTankElement {
    private GuiContainer screen;
    private int xCoord;
    private int yCoord;
    private int maxWidth;
    private int maxHeight;
    private FluidTank fluidTank;

    public FluidTankElement(GuiContainer screen, int xCoord, int yCoord, int maxWidth, int maxHeight, FluidTank fluidTank) {
        this.screen = screen;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.fluidTank = fluidTank;
    }

    public void renderTank() {
        if (this.fluidTank != null && this.fluidTank.getFluid() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int yBottomCoord = this.yCoord + this.maxHeight;
            float fittingBlocks = (float)this.maxHeight / 16.0f * (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
            int maxFullBlocks = (int)fittingBlocks;
            float leftoverHeightScale = fittingBlocks - (float)maxFullBlocks;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.fluidTank.getFluid().getFluid().getStill().toString());
            for (int block = 0; block < maxFullBlocks; ++block) {
                GuiHelper.drawTexturedRect(this.xCoord, yBottomCoord - block * 16 - 16, sprite, sprite.func_94211_a(), sprite.func_94216_b(), 1.0f);
            }
            GuiHelper.drawTexturedRectScaled(this.xCoord, yBottomCoord - maxFullBlocks * 16, sprite, sprite.func_94211_a(), sprite.func_94216_b(), leftoverHeightScale);
        }
    }

    public void renderTooltip(int mouseX, int mouseY) {
        if (GuiHelper.isPointInRegion(this.xCoord, this.yCoord, this.maxWidth, this.maxHeight, mouseX -= this.screen.getGuiLeft(), mouseY -= this.screen.getGuiTop()) && this.fluidTank != null && this.fluidTank.getFluid() != null) {
            String amount = String.format("%,d", this.fluidTank.getFluidAmount());
            String maxAmount = String.format("%,d", this.fluidTank.getCapacity());
            List<String> lines = Arrays.asList(this.fluidTank.getFluid().getFluid().getLocalizedName(null), TextFormatting.GRAY + amount + " / " + maxAmount + " mB");
            this.screen.func_146283_a(lines, mouseX, mouseY);
        }
    }
}

