/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.stargate;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Mouse;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.gui.container.stargate.StargateContainer;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.gui.element.tabs.TabAddress;
import tauri.dev.jsg.gui.element.tabs.TabBiomeOverlay;
import tauri.dev.jsg.gui.element.tabs.TabConfig;
import tauri.dev.jsg.gui.element.tabs.TabInfo;
import tauri.dev.jsg.gui.element.tabs.TabIris;
import tauri.dev.jsg.gui.element.tabs.TabScrollAble;
import tauri.dev.jsg.gui.element.tabs.TabSideEnum;
import tauri.dev.jsg.gui.element.tabs.TabbedContainerInterface;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.SetOpenTabToServer;
import tauri.dev.jsg.packet.stargate.SaveConfigToServer;
import tauri.dev.jsg.packet.stargate.SaveIrisCodeToServer;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.math.TemperatureHelper;

public class StargateContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_stargate.png");
    private final StargateContainer container;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private TabAddress milkyWayAddressTab;
    private TabAddress pegasusAddressTab;
    private TabAddress universeAddressTab;
    private TabIris irisTab;
    private TabConfig configTab;
    private TabInfo infoTab;
    private int energyStored;
    private int maxEnergyStored;
    private final BlockPos pos;

    public static TabConfig createConfigTab(JSGTileEntityConfig config, int guiXSize, int guiYSize, int guiLeft, int guiTop) {
        return (TabConfig)TabConfig.builder().setConfig(config).setGuiSize(guiXSize, guiYSize).setGuiPosition(guiLeft, guiTop).setTabPosition(-21, 77).setOpenX(-128).setHiddenX(-6).setTabSize(128, 96).setTabTitle(I18n.func_135052_a((String)"gui.configuration", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 165).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(326, 66).build();
    }

    public static TabBiomeOverlay createOverlayTab(EnumSet<BiomeOverlayEnum> supportedOverlay, int guiXSize, int guiYSize, int guiLeft, int guiTop) {
        return (TabBiomeOverlay)TabBiomeOverlay.builder().setSupportedOverlays(supportedOverlay).setSlotTexture(6, 179).setGuiSize(guiXSize, guiYSize).setGuiPosition(guiLeft, guiTop).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.biome_overlay", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 66).build();
    }

    public StargateContainerGui(BlockPos pos, StargateContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 173;
        this.pos = pos;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.milkyWayAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.MILKYWAY).setProgressColor(10009849).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 11).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.milky_way_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 0).build();
        this.pegasusAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.PEGASUS).setProgressColor(6015724).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 33).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.pegasus_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 22).build();
        this.universeAddressTab = (TabAddress)TabAddress.builder().setGateTile(this.container.gateTile).setSymbolType(SymbolTypeEnum.UNIVERSE).setProgressColor(0x707070).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 55).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.stargate.universe_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 44).build();
        this.configTab = StargateContainerGui.createConfigTab(this.container.gateTile.getConfig(), this.field_146999_f, this.field_147000_g, this.field_147003_i, this.field_147009_r);
        TabBiomeOverlay overlayTab = StargateContainerGui.createOverlayTab(this.container.gateTile.getSupportedOverlays(), this.field_146999_f, this.field_147000_g, this.field_147003_i, this.field_147009_r);
        this.irisTab = (TabIris)TabIris.builder().setCode(this.container.gateTile.getIrisCode()).setIrisMode(this.container.gateTile.getIrisMode()).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(69, 24).setOpenX(176).setHiddenX(54).setTabSize(128, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.iris_code", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(200, 113).setIconRenderPos(107, 6).setIconSize(22, 22).setIconTextureLocation(304, 88).build();
        this.infoTab = (TabInfo)TabInfo.builder().setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(45, 46).setOpenX(176).setHiddenX(30).setTabSize(152, 51).setTabTitle(I18n.func_135052_a((String)"gui.stargate.info", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(131, 6).setIconSize(22, 22).setIconTextureLocation(326, 88).build();
        this.irisTab.setOnTabClose(this::saveIrisCode);
        this.configTab.setOnTabClose(this::saveConfig);
        this.tabs.add(this.milkyWayAddressTab);
        this.tabs.add(this.pegasusAddressTab);
        this.tabs.add(this.universeAddressTab);
        this.tabs.add(this.configTab);
        this.tabs.add(overlayTab);
        this.tabs.add(this.irisTab);
        this.tabs.add(this.infoTab);
        this.container.field_75151_b.set(7, this.milkyWayAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(7)));
        this.container.field_75151_b.set(8, this.pegasusAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(8)));
        this.container.field_75151_b.set(9, this.universeAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(9)));
        this.container.field_75151_b.set(10, overlayTab.createAndSaveSlot((SlotItemHandler)this.container.func_75139_a(10)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        if (this.infoTab != null) {
            this.infoTab.clearStrings();
            int y = 22;
            long openedSince = this.container.gateTile.openedSince;
            if (openedSince > 0L) {
                long openedSeconds = this.container.gateTile.getOpenedSeconds();
                String format = TextFormatting.DARK_GREEN.toString();
                int maxTime = this.container.gateTile.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.TIME_LIMIT_TIME.id).getIntValue();
                if ((double)openedSeconds >= (double)maxTime * 0.75) {
                    format = TextFormatting.YELLOW.toString();
                }
                if (openedSeconds >= (long)maxTime) {
                    format = TextFormatting.RED.toString();
                }
                String openedTime = I18n.func_135052_a((String)"gui.stargate.state.opened", (Object[])new Object[0]) + " " + format + this.container.gateTile.getOpenedSecondsToDisplayAsMinutes();
                this.infoTab.addString(new TabInfo.InfoString(openedTime, 4, y));
                y += 9;
            }
            double gateTemperature = this.container.gateTile.gateHeat;
            double irisTemperature = this.container.gateTile.irisHeat;
            String format = TextFormatting.DARK_GREEN.toString();
            if (gateTemperature >= StargateClassicBaseTile.GATE_MAX_HEAT * 0.5) {
                format = TextFormatting.YELLOW.toString();
            }
            if (gateTemperature >= StargateClassicBaseTile.GATE_MAX_HEAT * 0.75) {
                format = TextFormatting.RED.toString();
            }
            this.infoTab.addString(new TabInfo.InfoString(I18n.func_135052_a((String)"gui.stargate.state.gate_temp", (Object[])new Object[0]) + " " + format + JSGConfig.General.visual.temperatureUnit.getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(gateTemperature).toKelvins()), 0), 4, y));
            y += 9;
            if (this.container.gateTile.isPhysicalIris()) {
                double maxHeat = this.container.gateTile.getMaxIrisHeat();
                format = TextFormatting.DARK_GREEN.toString();
                if (irisTemperature > maxHeat * 0.5) {
                    format = TextFormatting.YELLOW.toString();
                }
                if (irisTemperature > maxHeat * 0.75) {
                    format = TextFormatting.RED.toString();
                }
                this.infoTab.addString(new TabInfo.InfoString(I18n.func_135052_a((String)"gui.stargate.state.iris_temp", (Object[])new Object[0]) + " " + format + JSGConfig.General.visual.temperatureUnit.getTemperatureToDisplay(TemperatureHelper.asKelvins(TemperatureHelper.asCelsius(irisTemperature).toKelvins()), 0), 4, y));
            }
        }
        this.func_146276_q_();
        boolean hasAddressUpgrade = false;
        boolean hasMilkyWayUpgrade = false;
        boolean hasAtlantisUpgrade = false;
        boolean hasUniverseUpgrade = false;
        boolean hasIrisUpgrade = !this.container.func_75139_a(11).func_75211_c().func_190926_b();
        block6: for (int i2 = 0; i2 < 4; ++i2) {
            StargateClassicBaseTile.StargateUpgradeEnum upgrade;
            ItemStack itemStack = this.container.func_75139_a(i2).func_75211_c();
            if (itemStack.func_190926_b() || (upgrade = StargateClassicBaseTile.StargateUpgradeEnum.valueOf(itemStack.func_77973_b())) == null) continue;
            switch (upgrade) {
                case CHEVRON_UPGRADE: {
                    hasAddressUpgrade = true;
                    continue block6;
                }
                case MILKYWAY_GLYPHS: {
                    hasMilkyWayUpgrade = true;
                    continue block6;
                }
                case PEGASUS_GLYPHS: {
                    hasAtlantisUpgrade = true;
                    continue block6;
                }
                case UNIVERSE_GLYPHS: {
                    hasUniverseUpgrade = true;
                }
            }
        }
        this.milkyWayAddressTab.setMaxSymbols(SymbolMilkyWayEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.pegasusAddressTab.setMaxSymbols(SymbolPegasusEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.universeAddressTab.setMaxSymbols(SymbolUniverseEnum.getMaxSymbolsDisplay(hasAddressUpgrade));
        this.milkyWayAddressTab.setVisible(hasMilkyWayUpgrade);
        this.pegasusAddressTab.setVisible(hasAtlantisUpgrade);
        this.universeAddressTab.setVisible(hasUniverseUpgrade);
        this.irisTab.setVisible(hasIrisUpgrade);
        this.configTab.setVisible(this.container.isOperator);
        Tab.updatePositions(this.tabs);
        StargateClassicEnergyStorage energyStorageInternal = (StargateClassicEnergyStorage)((Object)this.container.gateTile.getCapability(CapabilityEnergy.ENERGY, null));
        if (energyStorageInternal != null) {
            this.energyStored = energyStorageInternal.getEnergyStoredInternally();
            this.maxEnergyStored = energyStorageInternal.getMaxEnergyStoredInternally();
        }
        for (i = 4; i < 7; ++i) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.container.func_75139_a(i).func_75211_c().getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage == null) continue;
            this.energyStored += energyStorage.getEnergyStored();
            this.maxEnergyStored += energyStorage.getMaxEnergyStored();
        }
        for (i = 7; i < 11; ++i) {
            ((Tab.SlotTab)this.container.func_75139_a(i)).updatePos();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        if (this.irisTab.isVisible() && !this.irisTab.isOpen()) {
            if (this.irisTab.getIrisMode() != this.container.gateTile.getIrisMode()) {
                this.irisTab.updateValue(this.container.gateTile.getIrisMode());
            }
            if (this.irisTab.getCode() != this.container.gateTile.getIrisCode()) {
                this.irisTab.updateValue(this.container.gateTile.getIrisCode());
            }
        }
        if (this.container.gateTile.getConfig().getOptions().size() != this.configTab.getConfig(false).getOptions().size()) {
            this.configTab.updateConfig(this.container.gateTile.getConfig(), true);
        }
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StargateContainerGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)512.0f);
        for (i = 0; i < 3 - this.container.gateTile.getSupportedCapacitors(); ++i) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 151 - 18 * i), (int)(this.field_147009_r + 27), (float)24.0f, (float)180.0f, (int)16, (int)16, (float)512.0f, (float)512.0f);
        }
        for (i = this.container.gateTile.getPowerTier(); i < 4; ++i) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 10 + 39 * i), (int)(this.field_147009_r + 69), (float)0.0f, (float)173.0f, (int)39, (int)6, (float)512.0f, (float)512.0f);
        }
        int width = Math.round((float)this.energyStored / (float)JSGConfig.Stargate.power.stargateEnergyStorage * 156.0f);
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 69, this.field_147003_i + 10 + width, this.field_147009_r + 69 + 6, -3397592, -9234922);
        switch (this.container.gateTile.getSymbolType()) {
            case MILKYWAY: {
                StargateContainerGui.func_146110_a((int)(this.field_147003_i + 137), (int)(this.field_147009_r + 4), (float)330.0f, (float)0.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
            case PEGASUS: {
                StargateContainerGui.func_146110_a((int)(this.field_147003_i + 137), (int)(this.field_147009_r + 4), (float)330.0f, (float)18.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
            case UNIVERSE: {
                StargateContainerGui.func_146110_a((int)(this.field_147003_i + 137), (int)(this.field_147009_r + 4), (float)330.0f, (float)36.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
        }
        boolean drawICFirstCable = false;
        boolean drawICSecondCable = false;
        block17: for (int i2 = 0; i2 < 7; ++i2) {
            if (!this.container.func_75139_a(i2).func_75216_d()) continue;
            if (i2 < 4) {
                drawICFirstCable = true;
            }
            switch (i2) {
                case 0: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 16), (int)(this.field_147009_r + 44), (float)18.0f, (float)239.0f, (int)31, (int)15, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 1: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 34), (int)(this.field_147009_r + 44), (float)3.0f, (float)239.0f, (int)13, (int)11, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 2: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 52), (int)(this.field_147009_r + 44), (float)0.0f, (float)239.0f, (int)2, (int)6, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 3: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 59), (int)(this.field_147009_r + 44), (float)33.0f, (float)254.0f, (int)13, (int)11, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 4: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 121), (int)(this.field_147009_r + 44), (float)0.0f, (float)225.0f, (int)14, (int)12, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 5: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 139), (int)(this.field_147009_r + 44), (float)14.0f, (float)225.0f, (int)4, (int)6, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 6: {
                    StargateContainerGui.func_146110_a((int)(this.field_147003_i + 147), (int)(this.field_147009_r + 44), (float)18.0f, (float)225.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
                    continue block17;
                }
            }
        }
        if (this.container.func_75139_a(11).func_75216_d()) {
            drawICSecondCable = true;
            ItemStack stack = this.container.func_75139_a(11).func_75211_c();
            if (stack.func_77973_b() == JSGItems.UPGRADE_SHIELD) {
                StargateContainerGui.func_146110_a((int)(this.field_147003_i + 98), (int)(this.field_147009_r + 33), (float)0.0f, (float)197.0f, (int)37, (int)28, (float)512.0f, (float)512.0f);
            }
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 59), (int)(this.field_147009_r + 44), (float)0.0f, (float)254.0f, (int)31, (int)15, (float)512.0f, (float)512.0f);
        }
        if (drawICFirstCable) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 50), (int)(this.field_147009_r + 62), (float)0.0f, (float)239.0f, (int)2, (int)6, (float)512.0f, (float)512.0f);
        }
        if (drawICSecondCable) {
            StargateContainerGui.func_146110_a((int)(this.field_147003_i + 54), (int)(this.field_147009_r + 62), (float)0.0f, (float)239.0f, (int)2, (int)6, (float)512.0f, (float)512.0f);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String caps = I18n.func_135052_a((String)"gui.stargate.capacitors", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(caps, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(caps), 16, 0x404040);
        String energyPercent = String.format("%.2f", Float.valueOf((float)this.energyStored / (float)this.maxEnergyStored * 100.0f)) + " %";
        this.field_146289_q.func_78276_b(energyPercent, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(energyPercent), 79, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.upgrades", (Object[])new Object[0]), 8, 16, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
        int transferred = this.container.gateTile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = TextFormatting.RED;
        }
        float toClose = this.container.gateTile.getEnergySecondsToClose();
        TextFormatting toCloseFormatting = TextFormatting.GRAY;
        if (toClose > 0.0f) {
            toCloseFormatting = toClose < (float)JSGConfig.Stargate.power.instabilitySeconds ? TextFormatting.DARK_RED : TextFormatting.GREEN;
        }
        if (this.func_146978_c(10, 69, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", this.energyStored, this.maxEnergyStored), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred), toCloseFormatting + String.format("%.2f s", Float.valueOf(toClose)));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            for (Tab tab : this.tabs) {
                if (!(tab instanceof TabScrollAble) || !tab.isVisible() || !tab.isOpen()) continue;
                ((TabScrollAble)tab).scroll(wheel);
            }
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.keyTyped(typedChar, keyCode);
        }
        if (keyCode == 1) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        this.saveConfig();
        this.saveIrisCode();
        super.func_146281_b();
    }

    private void saveConfig() {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SaveConfigToServer(this.pos, this.configTab.config));
        this.container.gateTile.setConfig(this.configTab.getConfig(true));
    }

    private void saveIrisCode() {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SaveIrisCodeToServer(this.pos, this.irisTab.getCode(), this.irisTab.getIrisMode()));
        this.container.gateTile.setIrisCode(this.irisTab.getCode());
        this.container.gateTile.setIrisMode(this.irisTab.getIrisMode());
    }
}

