/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.machine.orewashing;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tauri.dev.jsg.gui.container.machine.AbstractMachineContainerGuiUpdate;

public class OreWashingContainerGuiUpdate
extends AbstractMachineContainerGuiUpdate {
    public FluidStack fluidStack;

    public OreWashingContainerGuiUpdate() {
    }

    public OreWashingContainerGuiUpdate(int energyStored, FluidStack fluidStack, int energyTransferedLastTick, long machineStart, long machineEnd) {
        super(energyStored, energyTransferedLastTick, machineStart, machineEnd);
        this.fluidStack = fluidStack;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.fluidStack != null && this.fluidStack.getFluid() != null) {
            buf.writeBoolean(true);
            String name = FluidRegistry.getFluidName((FluidStack)this.fluidStack);
            buf.writeInt(name.length());
            buf.writeCharSequence((CharSequence)name, StandardCharsets.UTF_8);
            buf.writeInt(this.fluidStack.amount);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            int size = buf.readInt();
            this.fluidStack = FluidRegistry.getFluidStack((String)buf.readCharSequence(size, StandardCharsets.UTF_8).toString(), (int)buf.readInt());
        }
    }
}

