/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.dhd;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.fluid.JSGFluids;
import tauri.dev.jsg.gui.container.dhd.DHDAbstractContainer;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGui;
import tauri.dev.jsg.gui.element.Diode;
import tauri.dev.jsg.gui.element.FluidTankElement;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.gui.element.tabs.TabBiomeOverlay;
import tauri.dev.jsg.gui.element.tabs.TabbedContainerInterface;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.SetOpenTabToServer;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.util.ReactorStateEnum;

public abstract class DHDAbstractContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    private final DHDAbstractContainer container;
    private final FluidTankElement tank;
    private final List<Diode> diodes = new ArrayList<Diode>(3);
    private final List<Tab> tabs = new ArrayList<Tab>();
    public static final ResourceLocation BACKGROUND = new ResourceLocation("jsg", "textures/gui/container_dhd.png");

    public DHDAbstractContainerGui(DHDAbstractContainer container) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 172;
        this.container = container;
        container.tankNaquadah.setFluid(new FluidStack((Fluid)JSGFluids.NAQUADAH_MOLTEN_REFINED, 0));
        this.tank = new FluidTankElement(this, 152, 23, 16, 54, container.tankNaquadah);
        this.diodes.add(new Diode((GuiScreen)this, 8, 18, I18n.func_135052_a((String)"gui.dhd.crystalStatus", (Object[])new Object[0])).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.no_crystal", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.crystal_ok", (Object[])new Object[0])).setStatusMapper(() -> container.slotCrystal.func_75216_d() ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, 17, 18, I18n.func_135052_a((String)"gui.dhd.linkStatus", (Object[])new Object[0])).setDiodeStatus(Diode.DiodeStatus.OFF).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.linked", (Object[])new Object[0])).setStatusMapper(() -> container.dhdTile.isLinkedClient ? Diode.DiodeStatus.ON : Diode.DiodeStatus.OFF));
        this.diodes.add(new Diode((GuiScreen)this, 26, 18, I18n.func_135052_a((String)"gui.dhd.reactorStatus", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.OFF, I18n.func_135052_a((String)"gui.dhd.no_fuel", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.WARN, I18n.func_135052_a((String)"gui.dhd.standby", (Object[])new Object[0])).putStatus(Diode.DiodeStatus.ON, I18n.func_135052_a((String)"gui.dhd.running", (Object[])new Object[0])).setStatusMapper(() -> {
            switch (container.dhdTile.getReactorState()) {
                case ONLINE: {
                    return Diode.DiodeStatus.ON;
                }
                case STANDBY: {
                    return Diode.DiodeStatus.WARN;
                }
            }
            return Diode.DiodeStatus.OFF;
        }).setStatusStringMapper(() -> {
            switch (container.dhdTile.getReactorState()) {
                case NOT_LINKED: {
                    return I18n.func_135052_a((String)"gui.dhd.not_linked", (Object[])new Object[0]);
                }
                case NO_CRYSTAL: {
                    return I18n.func_135052_a((String)"gui.dhd.no_crystal", (Object[])new Object[0]);
                }
            }
            return null;
        }));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        TabBiomeOverlay overlayTab = StargateContainerGui.createOverlayTab(this.container.dhdTile.getSupportedOverlays(), this.field_146999_f, this.field_147000_g, this.field_147003_i, this.field_147009_r);
        this.tabs.add(overlayTab);
        this.container.field_75151_b.set(5, overlayTab.createAndSaveSlot((SlotItemHandler)this.container.func_75139_a(5)));
    }

    public void updateTank() {
        int capacity = JSGConfig.DialHomeDevice.mechanics.fluidCapacity;
        if (this.container.dhdTile.hasUpgrade(DHDAbstractTile.DHDUpgradeEnum.CAPACITY_UPGRADE)) {
            capacity = (int)((float)capacity * JSGConfig.DialHomeDevice.power.capacityUpgradeMultiplier);
        }
        if (capacity != this.container.tankNaquadah.getCapacity()) {
            this.container.tankNaquadah.setCapacity(capacity);
        }
        if (this.container.tankNaquadah.getFluidAmount() > capacity) {
            this.container.tankNaquadah.setFluid(new FluidStack((Fluid)JSGFluids.NAQUADAH_MOLTEN_REFINED, capacity));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.updateTank();
        this.func_146276_q_();
        Tab.updatePositions(this.tabs);
        ((Tab.SlotTab)this.container.func_75139_a(5)).updatePos();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.container.slotCrystal.func_75216_d()) {
            GlStateManager.func_179147_l();
            this.drawCrystal();
            GlStateManager.func_179084_k();
        }
        block6: for (int i = 1; i < 4; ++i) {
            if (!this.container.func_75139_a(i).func_75216_d()) continue;
            switch (i) {
                case 1: {
                    this.func_73729_b(this.field_147003_i + 16, this.field_147009_r + 57, 121, 173, 57, 12);
                    continue block6;
                }
                case 2: {
                    this.func_73729_b(this.field_147003_i + 34, this.field_147009_r + 57, 121, 185, 39, 9);
                    continue block6;
                }
                case 3: {
                    this.func_73729_b(this.field_147003_i + 52, this.field_147009_r + 57, 121, 194, 21, 6);
                    continue block6;
                }
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.container.dhdTile.getReactorState() == ReactorStateEnum.ONLINE) {
            int i;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(JSGFluids.NAQUADAH_MOLTEN_REFINED.getStill().toString());
            for (i = 0; i < 3; ++i) {
                this.func_175175_a(this.field_147003_i + 103 + 16 * i, this.field_147009_r + 60, sprite, 16, 16);
            }
            for (i = 0; i < 5; ++i) {
                GuiHelper.drawTexturedRectScaled(this.field_147003_i + 87 + 16 * i, this.field_147009_r + 87, sprite, 16, 16, 0.625f);
            }
        }
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_147003_i + 103, this.field_147009_r + 60, 0, 173, 48, 16);
        this.func_73729_b(this.field_147003_i + 84, this.field_147009_r + 77, 0, 189, 84, 10);
        GlStateManager.func_179084_k();
        this.drawAncientTitle();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.upgrades", (Object[])new Object[0]), 8, 29, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.tank.renderTank();
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(152, 23, 176, 32, 16, 54);
        GlStateManager.func_179084_k();
        boolean[] statuses = new boolean[this.diodes.size()];
        for (i = 0; i < this.diodes.size(); ++i) {
            statuses[i] = this.diodes.get(i).render(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        for (i = 0; i < this.diodes.size(); ++i) {
            if (!statuses[i]) continue;
            this.diodes.get(i).renderTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.tank.renderTooltip(mouseX, mouseY);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }

    public abstract void drawCrystal();

    public abstract void drawAncientTitle();
}

