/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.countdown;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import tauri.dev.jsg.gui.container.countdown.CountDownContainer;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGui;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.gui.element.tabs.TabConfig;
import tauri.dev.jsg.gui.element.tabs.TabScrollAble;
import tauri.dev.jsg.gui.element.tabs.TabbedContainerInterface;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.SetOpenTabToServer;
import tauri.dev.jsg.packet.stargate.SaveConfigToServer;

public class CountDownContainerGui
extends GuiContainer
implements TabbedContainerInterface {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_only_inv.png");
    private TabConfig configTab;
    private List<Tab> tabs;
    private final BlockPos pos;
    private final CountDownContainer container;

    public CountDownContainerGui(BlockPos pos, CountDownContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 128;
        this.pos = pos;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs = new ArrayList<Tab>();
        this.configTab = StargateContainerGui.createConfigTab(this.container.tile.getConfig(), this.field_146999_f, this.field_147000_g, this.field_147003_i, this.field_147009_r);
        this.tabs.add(this.configTab);
        this.configTab.setOnTabClose(this::saveConfig);
        this.configTab.setVisible(this.container.isOperator);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Tab.updatePositions(this.tabs);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.container.tile.getConfig().getOptions().size() != this.configTab.getConfig(false).getOptions().size()) {
            this.configTab.updateConfig(this.container.tile.getConfig(), true);
        }
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CountDownContainerGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)256.0f, (float)256.0f);
        this.func_73729_b(this.field_147003_i + 119 - 247 + 208, this.field_147009_r + 12 - 8, 209, 0, 39, 8);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            for (Tab tab : this.tabs) {
                if (!(tab instanceof TabScrollAble) || !tab.isVisible() || !tab.isOpen()) continue;
                ((TabScrollAble)tab).scroll(wheel);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.keyTyped(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        this.saveConfig();
        super.func_146281_b();
    }

    private void saveConfig() {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SaveConfigToServer(this.pos, this.configTab.config));
        this.container.tile.setConfig(this.configTab.getConfig(true));
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }
}

