/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.base.JSGGuiBase;
import tauri.dev.jsg.gui.base.JSGGuiButton;
import tauri.dev.jsg.gui.element.NumberOnlyTextField;
import tauri.dev.jsg.item.linkable.gdo.GDOActionEnum;
import tauri.dev.jsg.item.linkable.gdo.GDOActionPacketToServer;
import tauri.dev.jsg.item.linkable.gdo.GDOItem;
import tauri.dev.jsg.item.linkable.gdo.GDOMessages;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;

public class GuiSendCode
extends JSGGuiBase {
    EnumHand hand;
    String message = null;
    int messageColor = 0xE30000;
    JSGGuiButton sendButton;
    JSGGuiButton backButton;
    NumberOnlyTextField codeField;
    protected List<JSGGuiButton> keyPadButtons = new ArrayList<JSGGuiButton>();

    public GuiSendCode(EnumHand hand) {
        super(260, 200, 4, -16777216, -232314061, 7042700, 4);
        this.hand = hand;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.keyPadButtons.clear();
        this.codeField = new NumberOnlyTextField(0, Minecraft.func_71410_x().field_71466_p, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 75, 160, 20);
        this.codeField.func_146203_f(JSGConfig.Stargate.iris.irisCodeLength);
        this.codeField.func_146195_b(true);
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (y != 3) {
                    this.keyPadButtons.add(new JSGGuiButton(i + 3, this.field_146294_l / 2 - 48 + 33 * x, this.field_146295_m / 2 - 35 + 33 * y, 30, 30, "" + (i + 1)));
                    ++i;
                    continue;
                }
                if (x == 0) {
                    this.sendButton = new JSGGuiButton(1, this.field_146294_l / 2 - 48, this.field_146295_m / 2 - 35 + 33 * y, 30, 30, "OK");
                }
                if (x == 1) {
                    this.keyPadButtons.add(new JSGGuiButton(12, this.field_146294_l / 2 - 48 + 33, this.field_146295_m / 2 - 35 + 33 * y, 30, 30, "0"));
                }
                if (x != 2) continue;
                this.backButton = new JSGGuiButton(13, this.field_146294_l / 2 - 48 + 66, this.field_146295_m / 2 - 35 + 33 * y, 30, 30, "<-");
            }
        }
        this.sendButton.field_146124_l = false;
        this.backButton.field_146124_l = false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.translateToCenter();
        this.drawBackground();
        this.drawString(I18n.func_135052_a((String)"gui.gdo.send_code", (Object[])new Object[0]), 5, 5, 43520);
        GlStateManager.func_179121_F();
        this.codeField.func_146194_f();
        this.sendButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        this.backButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        for (JSGGuiButton guiButton : this.keyPadButtons) {
            guiButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        if (this.message != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, this.message, this.field_146294_l / 2, this.codeField.field_146210_g + 25, this.messageColor);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.refreshButtonEnable();
        this.codeField.func_146201_a(typedChar, keyCode);
        if (keyCode == 28) {
            this.sendCode();
        }
        this.playButtonPressSound();
    }

    private void refreshButtonEnable() {
        this.backButton.field_146124_l = this.sendButton.field_146124_l = !this.codeField.func_146179_b().isEmpty();
        for (JSGGuiButton button : this.keyPadButtons) {
            button.field_146124_l = this.codeField.func_146179_b().length() < JSGConfig.Stargate.iris.irisCodeLength;
        }
    }

    private void playButtonPressSound() {
        JSGSoundHelper.playSoundEventClientSide((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c(), SoundEventEnum.GUI_SEND_CODE_BUTTON_PRESS);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.codeField.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.sendButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            this.playButtonPressSound();
            this.sendCode();
        }
        if (this.backButton.func_146116_c(this.field_146297_k, mouseX, mouseY) && this.codeField.func_146179_b().length() > 0) {
            this.codeField.func_146180_a(this.codeField.func_146179_b().substring(0, this.codeField.func_146179_b().length() - 1));
            this.playButtonPressSound();
        }
        for (GuiButton guiButton : this.keyPadButtons) {
            if (!guiButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            this.playButtonPressSound();
            this.codeField.func_146180_a(this.codeField.func_146179_b() + guiButton.field_146126_j);
        }
        this.codeField.func_146195_b(true);
        this.refreshButtonEnable();
    }

    public void sendCode() {
        if (GDOItem.isLinked(this.field_146297_k.field_71439_g.func_184586_b(this.hand))) {
            if (this.codeField.func_146179_b().isEmpty()) {
                this.message = GDOMessages.CODE_NOT_SET.textComponent.func_150254_d();
                this.messageColor = 0xE30000;
                this.codeField.func_146195_b(true);
                return;
            }
            int code = Integer.parseInt(this.codeField.func_146179_b());
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new GDOActionPacketToServer(GDOActionEnum.SEND_CODE, this.hand, code, false));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

