/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.entity.friendly;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tauri.dev.jsg.entity.JSGEnergyProjectile;
import tauri.dev.jsg.entity.JSGTradeableEntity;
import tauri.dev.jsg.entity.ai.JSGLookAtTradePlayerAI;
import tauri.dev.jsg.entity.ai.JSGTokraLookForRingsAI;
import tauri.dev.jsg.entity.ai.JSGTradePlayerAI;
import tauri.dev.jsg.entity.trading.ITradeList;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.tools.EnergyWeapon;
import tauri.dev.jsg.util.JSGItemStackHandler;

public class TokraEntity
extends JSGTradeableEntity
implements IRangedAttackMob,
INpc {
    public static final int MAIN_HAND_SLOT = 0;
    public static final int OFF_HAND_SLOT = 1;
    public final JSGItemStackHandler ITEM_HANDLER = new JSGItemStackHandler(12);
    private final ItemStack ZAT_ITEM = new ItemStack((Item)JSGItems.ZAT);
    private final ItemStack STAFF_ITEM = new ItemStack((Item)JSGItems.STAFF);
    private final Random RANDOM = new Random();
    @Nullable
    private MerchantRecipeList buyingList;
    @Nullable
    private EntityPlayer buyingPlayer;
    private final float MOVEMENT_SPEED = 0.4f;

    public TokraEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.func_70659_e(0.4f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
        this.initTokra();
    }

    private void initTokra() {
        if (this.RANDOM.nextInt(100) < 2) {
            this.ITEM_HANDLER.setStackInSlot(0, this.STAFF_ITEM);
        } else {
            this.ITEM_HANDLER.setStackInSlot(0, this.ZAT_ITEM);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, (double)0.4f, 20, 10.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)0.4f, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JSGTradePlayerAI(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JSGLookAtTradePlayerAI(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JSGTokraLookForRingsAI(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, (double)0.4f));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{TokraEntity.class}));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, IMob.field_82192_a));
    }

    public void moveFromRingsPlatform() {
        BlockPos pos = new BlockPos(Math.random() * 25.0, this.field_70163_u, Math.random() * 25.0);
        this.func_70671_ap().func_75650_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 3), (double)pos.func_177952_p(), 10.0f, (float)this.func_70646_bf());
        this.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p(), 0.48000001907348633);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    @Override
    public void populateBuyingList() {
        List<ITradeList> trades;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if ((trades = this.getTrades()) != null) {
            for (ITradeList trade : trades) {
                trade.addMerchantRecipe(this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    @Override
    public List<ITradeList> getTrades() {
        return null;
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        return livingData;
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return (stack.func_77973_b() != Items.field_151110_aK || !this.func_70631_g_() || !this.func_184218_aH()) && super.func_175448_a(stack);
    }

    @ParametersAreNonnullByDefault
    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151057_cb) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (this.func_70089_S() && !this.isTrading() && !player.func_70093_af()) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @ParametersAreNonnullByDefault
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        HashMap<ItemArmor, Float> items = new HashMap<ItemArmor, Float>();
        items.put(Items.field_151024_Q, Float.valueOf(0.07f));
        items.put(Items.field_151021_T, Float.valueOf(0.07f));
        items.put(Items.field_151027_R, Float.valueOf(0.07f));
        items.put(Items.field_151026_S, Float.valueOf(0.07f));
        Random rand = new Random();
        for (Item item : items.keySet()) {
            if (!(rand.nextFloat() < ((Float)items.get(item)).floatValue())) continue;
            this.func_70099_a(new ItemStack(item), 0.0f);
        }
        if (rand.nextFloat() < 0.5f) {
            EntitySilverfish goauld = new EntitySilverfish(this.field_70170_p);
            goauld.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, rand.nextFloat() * 360.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)goauld);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof EnergyWeapon) {
            EnergyWeapon item = (EnergyWeapon)this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            item.playShootSound(this.field_70170_p, (Entity)this);
            this.field_70170_p.func_72838_d((Entity)JSGEnergyProjectile.createEnergyBall(this.field_70170_p, (EntityLivingBase)this, target, item));
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public float func_70047_e() {
        return 1.7f;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
        return null;
    }

    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public void func_70933_a(@Nonnull MerchantRecipe recipe) {
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (!s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        super.func_145748_c_();
        String s1 = "default";
        TextComponentTranslation itextcomponent = new TextComponentTranslation("entity.Tokra." + s1, new Object[0]);
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Nonnull
    public BlockPos func_190671_u_() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        for (int i = 0; i < this.ITEM_HANDLER.getSize(); ++i) {
            this.func_70099_a(this.ITEM_HANDLER.getStackInSlot(i), 0.0f);
        }
    }

    public boolean func_174820_d(int inventorySlot, @Nonnull ItemStack itemStackIn) {
        if (inventorySlot < 0 || inventorySlot >= this.ITEM_HANDLER.getSize()) {
            return false;
        }
        this.ITEM_HANDLER.setStackInSlot(inventorySlot, itemStackIn);
        return true;
    }

    public boolean func_70601_bi() {
        return false;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
        int slotIndex = slotIn.func_188452_c();
        if (slotIn.func_188453_a() != EntityEquipmentSlot.Type.HAND) {
            slotIndex += 2;
        }
        if (slotIndex >= this.ITEM_HANDLER.getSize()) {
            return;
        }
        this.ITEM_HANDLER.setStackInSlot(slotIndex, stack);
    }

    @Nonnull
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        int slotIndex = slotIn.func_188452_c();
        if (slotIn.func_188453_a() != EntityEquipmentSlot.Type.HAND) {
            slotIndex += 2;
        }
        if (slotIndex >= this.ITEM_HANDLER.getSize()) {
            return ItemStack.field_190927_a;
        }
        return this.ITEM_HANDLER.getStackInSlot(slotIndex);
    }

    private void updateItemHeld() {
        if (!this.field_70170_p.field_72995_K) {
            this.setHeldItemMainhand(this.ITEM_HANDLER.getStackInSlot(0));
            this.setHeldItemOffhand(this.ITEM_HANDLER.getStackInSlot(1));
        }
    }

    protected void func_175445_a(EntityItem itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        if (!stack.func_190926_b()) {
            for (int i = 0; i < this.ITEM_HANDLER.getSize(); ++i) {
                ItemStack inventoryStack = this.ITEM_HANDLER.getStackInSlot(i);
                if (!inventoryStack.func_190926_b()) continue;
                this.func_71001_a((Entity)itemEntity, stack.func_190916_E());
                this.ITEM_HANDLER.setStackInSlot(i, stack);
                itemEntity.func_70106_y();
                break;
            }
        }
        this.updateItemHeld();
    }

    @Nonnull
    public ItemStack func_184614_ca() {
        return this.func_184586_b(EnumHand.MAIN_HAND);
    }

    public void setHeldItemMainhand(ItemStack stack) {
        this.func_184611_a(EnumHand.MAIN_HAND, stack);
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        return this.func_184586_b(EnumHand.OFF_HAND);
    }

    public void setHeldItemOffhand(ItemStack stack) {
        this.func_184611_a(EnumHand.OFF_HAND, stack);
    }

    @Nonnull
    public ItemStack func_184586_b(@Nonnull EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        }
        if (hand == EnumHand.OFF_HAND) {
            return this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Items")) {
            NBTTagList nbtList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                NBTTagCompound comp = nbtList.func_150305_b(i);
                int slot = comp.func_74762_e("Slot");
                if (slot < 0 || slot >= this.ITEM_HANDLER.getSize()) continue;
                this.ITEM_HANDLER.setStackInSlot(slot, new ItemStack(comp));
            }
        }
        this.updateItemHeld();
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < this.ITEM_HANDLER.getSize(); ++i) {
            ItemStack stack = this.ITEM_HANDLER.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            stack.func_77955_b(tag);
            nbtList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Items", (NBTBase)nbtList);
    }
}

