/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.stargate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;

public class StargateDimensionConfigEntry {
    public int energyToOpen;
    public int keepAlive;
    public ArrayList<String> groups;
    public Map<BiomeOverlayEnum, Integer> milkyWayOrigins;

    public StargateDimensionConfigEntry(int energyToOpen, int keepAlive, ArrayList<String> groups) {
        this(energyToOpen, keepAlive, groups, new HashMap<BiomeOverlayEnum, Integer>());
    }

    public StargateDimensionConfigEntry(int energyToOpen, int keepAlive, ArrayList<String> groups, @Nonnull Map<BiomeOverlayEnum, Integer> origins) {
        this.energyToOpen = energyToOpen;
        this.keepAlive = keepAlive;
        this.groups = groups;
        this.milkyWayOrigins = origins;
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
    }

    public String toString() {
        if (this.milkyWayOrigins.size() > 0) {
            StringBuilder originIdsString = new StringBuilder("[");
            int i = 0;
            for (BiomeOverlayEnum k : this.milkyWayOrigins.keySet()) {
                originIdsString.append(k.toString()).append(": ").append(this.milkyWayOrigins.get((Object)k));
                if (++i >= this.milkyWayOrigins.size()) continue;
                originIdsString.append(", ");
            }
            originIdsString.append("]");
            return "[open=" + this.energyToOpen + ", keepAlive=" + this.keepAlive + ", groups: '" + this.groups.toString() + "', milkyWayOrigins: '" + originIdsString + "']";
        }
        return "[open=" + this.energyToOpen + ", keepAlive=" + this.keepAlive + ", groups: '" + this.groups.toString() + "']";
    }

    public boolean isGroupEqual(StargateDimensionConfigEntry other) {
        if (this.groups == null) {
            return false;
        }
        if (other.groups == null) {
            return false;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!other.groups.contains(this.groups.get(i))) continue;
            return true;
        }
        return this.groups.equals(other.groups);
    }
}

