/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.origins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.loader.model.OBJLoader;
import tauri.dev.jsg.loader.model.OBJModel;
import tauri.dev.jsg.loader.texture.Texture;

public class OriginsLoader {
    public static final String MODELS_PATH = "assets/models/origins/";
    public static final String TEXTURES_PATH = "assets/textures/origins/";
    public static final String RING_END = "_ring.obj";
    public static final String DHD_END = "_dhd.obj";
    public static final String DHD_LIGHT_END = "_dhd_light.obj";
    public static final String TEXTURE_END = ".png";
    public static final String BASE = "origin_";
    public static final ArrayList<Integer> NOT_LOADED_ORIGINS = new ArrayList();
    public static final int DEFAULT_ORIGIN_ID = 5;
    public static final int MOD_POINT_OF_ORIGINS_COUNT = 6;

    public static File getOriginFile(EnumOriginFileType fileType, int originId) {
        switch (fileType) {
            case MODEL_RING: {
                return new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + RING_END);
            }
            case MODEL_DHD: {
                return new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + DHD_END);
            }
            case MODEL_DHD_LIGHT: {
                return new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + DHD_LIGHT_END);
            }
        }
        return new File(JSG.modConfigDir, "jsg/assets/textures/origins/origin_" + originId + TEXTURE_END);
    }

    private static void checkDirectory() {
        try {
            File models = new File(JSG.modConfigDir, "jsg/assets/models/origins/");
            File textures = new File(JSG.modConfigDir, "jsg/assets/textures/origins/");
            if (!models.exists()) {
                Files.createDirectories(models.toPath(), new FileAttribute[0]);
            }
            if (!textures.exists()) {
                Files.createDirectories(textures.toPath(), new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            JSG.error("Error while creating folders for custom resources!", e);
        }
    }

    public static void registerTextures(Map<ResourceLocation, Texture> texturesArray) throws IOException {
        OriginsLoader.checkDirectory();
        if (JSGConfig.Stargate.pointOfOrigins.additionalOrigins.length < 1) {
            return;
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"JSG - Custom PoO models", (int)JSGConfig.Stargate.pointOfOrigins.additionalOrigins.length);
        for (String s : JSGConfig.Stargate.pointOfOrigins.additionalOrigins) {
            int id = Integer.parseInt(s.split(":")[0]);
            progressBar.step("Origin " + id);
            if (!OriginsLoader.getOriginFile(EnumOriginFileType.TEXTURE, id).exists()) {
                NOT_LOADED_ORIGINS.add(id);
                JSG.error("Origin texture not found! [" + id + "]");
                continue;
            }
            texturesArray.put(OriginsLoader.getResource(EnumOriginFileType.TEXTURE, id), new Texture(TextureUtil.func_177053_a((InputStream)Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.TEXTURE, id).toPath(), new OpenOption[0]))));
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public static void loadModels(Map<ResourceLocation, OBJModel> modelsArray) throws IOException {
        OriginsLoader.checkDirectory();
        if (JSGConfig.Stargate.pointOfOrigins.additionalOrigins.length < 1) {
            return;
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"JSG - Custom PoO models", (int)JSGConfig.Stargate.pointOfOrigins.additionalOrigins.length);
        for (String s : JSGConfig.Stargate.pointOfOrigins.additionalOrigins) {
            int id = Integer.parseInt(s.split(":")[0]);
            progressBar.step("Origin " + id);
            if (!(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD, id).exists() && OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_RING, id).exists() && OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD_LIGHT, id).exists())) {
                NOT_LOADED_ORIGINS.add(id);
                JSG.error("Origin model not found! [" + id + "]");
                continue;
            }
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_DHD, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD, id).toPath(), new OpenOption[0])));
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_RING, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_RING, id).toPath(), new OpenOption[0])));
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_DHD_LIGHT, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD_LIGHT, id).toPath(), new OpenOption[0])));
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    public static ResourceLocation getResource(EnumOriginFileType fileType, int originId) {
        if (NOT_LOADED_ORIGINS.contains(originId)) {
            originId = 5;
        }
        if (fileType != EnumOriginFileType.TEXTURE) {
            return new ResourceLocation("jsg", "models/tesr/milkyway/" + (fileType == EnumOriginFileType.MODEL_RING ? "ring/" : "") + BASE + originId + (fileType == EnumOriginFileType.MODEL_DHD_LIGHT ? "_light" : "") + ".obj");
        }
        return new ResourceLocation("jsg", "textures/gui/symbol/milkyway/origin_" + originId + TEXTURE_END);
    }

    public static enum EnumOriginFileType {
        MODEL_RING,
        MODEL_DHD,
        MODEL_DHD_LIGHT,
        TEXTURE;

    }
}

