/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.ingame;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import tauri.dev.jsg.config.ingame.ITileConfigEntry;
import tauri.dev.jsg.config.ingame.JSGConfigOption;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;

public class JSGTileEntityConfig {
    private List<JSGConfigOption> options;

    public JSGTileEntityConfig() {
        this.options = new ArrayList<JSGConfigOption>();
    }

    public JSGTileEntityConfig(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public void addOption(@Nonnull JSGConfigOption option) {
        this.options.add(option);
    }

    public List<JSGConfigOption> getOptions() {
        return this.options;
    }

    @Nonnull
    public JSGConfigOption getOption(int id) {
        return Objects.requireNonNull(this.getOption(id, false));
    }

    @Nullable
    public JSGConfigOption getOption(int id, boolean canBeNull) {
        if (id < this.options.size()) {
            return this.options.get(id);
        }
        if (canBeNull) {
            return null;
        }
        return new JSGConfigOption(id).setLabel("error while getting option! (" + id + ")").setComment("").setType(JSGConfigOptionTypeEnum.TEXT).setValue("");
    }

    public void clearOptions() {
        this.options.clear();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Size", this.options.size());
        for (int i = 0; i < this.options.size(); ++i) {
            compound.func_74782_a("Option" + i, (NBTBase)this.options.get(i).serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        int size = compound.func_74762_e("Size");
        this.options.clear();
        for (int i = 0; i < size; ++i) {
            this.options.add(new JSGConfigOption(compound.func_74775_l("Option" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.options.size());
        for (JSGConfigOption option : this.options) {
            option.toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.options = new ArrayList<JSGConfigOption>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.options.add(new JSGConfigOption(buf));
        }
    }

    public static void initConfig(JSGTileEntityConfig config, ITileConfigEntry[] entries) {
        JSGTileEntityConfig.initConfig(config, Arrays.asList(entries));
    }

    public static void initConfig(JSGTileEntityConfig config, List<ITileConfigEntry> entries) {
        if (config.getOptions().size() != entries.size()) {
            for (ITileConfigEntry option : entries) {
                if (config.getOption(option.getId(), true) != null) continue;
                JSGConfigOption optionNew = new JSGConfigOption(option.getId()).setType(option.getType());
                if (option.getType() == JSGConfigOptionTypeEnum.SWITCH) {
                    optionNew.setPossibleValues(option.getPossibleValues());
                }
                optionNew.setLabel(option.getLabel()).setValue(option.getDefaultValue()).setDefaultValue(option.getDefaultValue()).setMinInt(option.getMin()).setMaxInt(option.getMax()).setComment(option.getComment());
                config.addOption(optionNew);
            }
        }
        for (ITileConfigEntry option : entries) {
            JSGConfigOption o = config.getOption(option.getId(), true);
            if (o == null) continue;
            if (o.type != option.getType()) {
                o.setType(option.getType());
            }
            if (!Objects.equals(o.defaultValue, option.getDefaultValue())) {
                o.setDefaultValue(option.getDefaultValue());
            }
            if (!Objects.equals(o.getLabel(), option.getLabel())) {
                o.setLabel(option.getLabel());
            }
            if (!o.getComment().equals(Arrays.asList(option.getComment()))) {
                o.setComment(option.getComment());
            }
            o.setMaxInt(option.getMax());
            o.setMinInt(option.getMin());
            if (option.getType() != JSGConfigOptionTypeEnum.SWITCH || option.getPossibleValues().size() == o.possibleValues.size()) continue;
            o.setPossibleValues(option.getPossibleValues()).setDefaultValue(option.getDefaultValue()).setValue(option.getDefaultValue());
        }
    }
}

