/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.config.stargate.StargateTimeLimitModeEnum;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.util.math.TemperatureHelper;

public class JSGConfig {
    private static final String CONFIG_FILE_NAME = "jsg/jsgConfig_3.1/";

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/worldgen", category="worldgen")
    @Config.LangKey(value="config.jsg.worldgen")
    public static class WorldGen {
        @Config.Name(value="Mysterious pages")
        @Config.Comment(value={"Mysterious pages settings"})
        public static MystPage mystPage = new MystPage();
        @Config.Name(value="Ores")
        @Config.Comment(value={"Ores generator settings"})
        public static Ores ores = new Ores();
        @Config.Name(value="Structures")
        @Config.Comment(value={"Structures generator settings"})
        public static Structures structures = new Structures();

        public static class Structures {
            @Config.Name(value="Enable random stargate generator")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Generate stargate in world random.", "CAN BE OVERRIDE IN STRUCTURES CONFIG FILE", "SIDE: SERVER"})
            public boolean stargateRandomGeneratorEnabled = true;
            @Config.Name(value="Enable random structures generator")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Enable generation of structures in the world.", "This will not disable the stargate generation!", "CAN BE OVERRIDE IN STRUCTURES CONFIG FILE", "SIDE: SERVER"})
            public boolean structuresRandomGeneratorEnabled = true;
            @Config.Name(value="Chance of generating stargates in Overworld")
            @Config.RequiresMcRestart
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"CAN BE OVERRIDE IN STRUCTURES CONFIG FILE", "SIDE: SERVER"})
            public float stargateRGChanceOverworld = 1.0E-4f;
            @Config.Name(value="Chance of generating stargates in End")
            @Config.RequiresMcRestart
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"CAN BE OVERRIDE IN STRUCTURES CONFIG FILE", "SIDE: SERVER"})
            public float stargateRGChanceTheEnd = 7.0E-5f;
        }

        public static class Ores {
            @Config.Name(value="Enable Naquadah ore generation")
            @Config.Comment(value={"Do you want to spawn naquadah ores in the Nether?", "SIDE: SERVER"})
            public boolean naquadahEnable = true;
            @Config.Name(value="Naquadah vein size")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int naquadahVeinSize = 8;
            @Config.Name(value="Naquadah max veins in chunk")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int naquadahMaxVeinInChunk = 16;
            @Config.Name(value="Enable Trinium ore generation")
            @Config.Comment(value={"Do you want to spawn trinium ores in the End?", "SIDE: SERVER"})
            public boolean triniumEnabled = true;
            @Config.Name(value="Trinium vein size")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int triniumVeinSize = 4;
            @Config.Name(value="Trinium max veins in chunk")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int triniumMaxVeinInChunk = 16;
            @Config.Name(value="Enable Titanium ore generation")
            @Config.Comment(value={"Do you want to spawn titanium ores in the Overworld?", "SIDE: SERVER"})
            public boolean titaniumEnable = true;
            @Config.Name(value="Titanium vein size")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int titaniumVeinSize = 4;
            @Config.Name(value="Titanium max veins in chunk")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int titaniumMaxVeinInChunk = 16;
        }

        public static class MystPage {
            @Config.Name(value="Max XZ-coords generation")
            @Config.RangeInt(min=1000, max=30000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int maxOverworldCoords = 15000;
            @Config.Name(value="Min XZ-coords generation")
            @Config.RangeInt(min=1000, max=30000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int minOverworldCoords = 5000;
            @Config.Name(value="Chance of despawning DHD")
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public double despawnDhdChance = 0.05;
            @Config.Name(value="Mysterious page cooldown")
            @Config.RangeInt(min=0, max=400)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int pageCooldown = 40;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/beamers", category="beamers")
    @Config.LangKey(value="config.jsg.beamers")
    public static class Beamer {
        @Config.Name(value="Mechanics")
        @Config.Comment(value={"Beamers Mechanics settings"})
        public static Mechanics mechanics = new Mechanics();
        @Config.Name(value="Container")
        @Config.Comment(value={"Beamers Container settings"})
        public static Container container = new Container();
        @Config.Name(value="Visual")
        @Config.Comment(value={"Beamers Video settings"})
        public static Visual visual = new Visual();
        @Config.Name(value="Power")
        @Config.Comment(value={"Beamers Power settings"})
        public static Power power = new Power();

        public static class Power {
            @Config.Name(value="Energy/tick needed to keep laser alive")
            @Config.RangeInt(min=10000, max=500000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int laserEnergy = 25360;
        }

        public static class Visual {
            @Config.Name(value="Should the beam be responsive to fluid color")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean enableFluidBeamColorization = true;
        }

        public static class Container {
            @Config.Name(value="Fluid buffer capacity")
            @Config.RangeInt(min=3000, max=600000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int fluidCapacity = 60000;
            @Config.Name(value="Energy buffer capacity")
            @Config.RangeInt(min=3000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int energyCapacity = 17820000;
            @Config.Name(value="Energy buffer max transfer")
            @Config.RangeInt(min=1)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int energyTransfer = 26360;
            @Config.Name(value="Fluid max transfer")
            @Config.RangeInt(min=1, max=5000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int fluidTransfer = 100;
            @Config.Name(value="Item max transfer")
            @Config.RangeInt(min=1, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int itemTransfer = 4;
        }

        public static class Mechanics {
            @Config.Name(value="Max gate-beamer distance")
            @Config.RangeInt(min=3, max=50)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int reach = 10;
            @Config.Name(value="Interval of signals being send to OC about transfers (in ticks)")
            @Config.RangeInt(min=10, max=400)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int signalIntervalTicks = 20;
            @Config.Name(value="Damage entities in a beam")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean damageEntities = true;
            @Config.Name(value="Destroy blocks in a beam")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean destroyBlocks = true;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/dhd", category="dhd")
    @Config.LangKey(value="config.jsg.dhd")
    public static class DialHomeDevice {
        @Config.Name(value="Mechanics")
        @Config.Comment(value={"DHD Mechanics settings"})
        public static Mechanics mechanics = new Mechanics();
        @Config.Name(value="Power")
        @Config.Comment(value={"DHD Power settings"})
        public static Power power = new Power();
        @Config.Name(value="Audio")
        @Config.Comment(value={"DHD Audio settings"})
        public static Audio audio = new Audio();
        @Config.Name(value="Visual")
        @Config.Comment(value={"DHD Video settings"})
        public static Visual visual = new Visual();

        public static class Visual {
            @Config.Name(value="Enable hint when dialing on DHDs with notebook page")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean enablePageHint = true;
            @Config.Name(value="Dialing helper colors")
            @Config.Comment(value={"Set colors of each dial helper button", "You should use HEX values", "SIDE: CLIENT"})
            public Map<String, String> pageHintColors = new HashMap<String, String>(){
                {
                    this.put("Normal", "#7FFFFF");
                    this.put("ExtraSymbols", "#E56BEE");
                    this.put("Origin", "#7FFF7F");
                }
            };
            @Config.Name(value="Enable opening last chevron while dialing with dhd")
            @Config.Comment(value={"Enable opening last chevron while dialing milkyway gate with dhd", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"})
            public boolean dhdLastOpen = true;
            @Config.Name(value="Enable old mechanics of DHD OC dialing")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean enableOldBug = false;
        }

        public static class Audio {
            @Config.Name(value="Enable press sound when dialing with computer")
            @Config.Comment(value={"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"})
            public boolean computerDialSound = false;
        }

        public static class Power {
            @Config.Name(value="Capacity upgrade multiplier")
            @Config.RangeDouble(min=1.0, max=5.0)
            @Config.Comment(value={"When capacity upgrade is placed in the DHD,", "then multiply internal capacity by this number", "SIDE: SERVER/CLIENT"})
            @Config.SlidingOption
            public float capacityUpgradeMultiplier = 2.0f;
            @Config.Name(value="Energy per 1mB Naquadah")
            @Config.RangeInt(min=1, max=50000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int energyPerNaquadah = 10240;
            @Config.Name(value="Generation multiplier")
            @Config.RangeInt(min=1, max=5)
            @Config.Comment(value={"Energy per 1mB is multiplied by this", "Consumed mB/t is equal to this", "SIDE: SERVER"})
            @Config.SlidingOption
            public int powerGenerationMultiplier = 1;
            @Config.Name(value="Efficiency upgrade multiplier")
            @Config.RangeDouble(min=1.0, max=5.0)
            @Config.Comment(value={"Energy per 1mB is multiplied by this", "when efficiency upgrade is placed in the DHD", "SIDE: SERVER"})
            @Config.SlidingOption
            public float efficiencyUpgradeMultiplier = 1.4f;
            @Config.Name(value="Cold fusion reactor activation energy level")
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public double activationLevel = 0.9;
            @Config.Name(value="Cold fusion reactor deactivation energy level")
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public double deactivationLevel = 0.98;
        }

        public static class Mechanics {
            @Config.Name(value="DHD range's radius horizontal")
            @Config.RangeInt(min=1, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int rangeFlat = 25;
            @Config.Name(value="DHD range's radius vertical")
            @Config.RangeInt(min=1, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int rangeVertical = 15;
            @Config.Name(value="Universe dialer max horizontal reach radius")
            @Config.RangeInt(min=0, max=64)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int universeDialerReach = 10;
            @Config.Name(value="DHD's max fluid capacity")
            @Config.RangeInt(min=1, max=128000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int fluidCapacity = 16000;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/transportrings", category="transportrings")
    @Config.LangKey(value="config.jsg.rings")
    public static class Rings {
        @Config.Name(value="Mechanics")
        @Config.Comment(value={"Rings Mechanics settings"})
        public static Mechanics mechanics = new Mechanics();
        @Config.Name(value="Power")
        @Config.Comment(value={"Rings Power settings"})
        public static Power power = new Power();

        public static class Power {
            @Config.Name(value="Transport Rings active power draw")
            @Config.Comment(value={"Energy extracted from rings every tick when they are active (calculated by distance from these rings)", "SIDE: SERVER"})
            @Config.RangeInt(min=0, max=100)
            @Config.SlidingOption
            public int ringsKeepAliveBlockToEnergyRatioPerTick = 2;
            @Config.Name(value="Transport Rings teleport power draw")
            @Config.Comment(value={"Energy extracted from rings when they teleport LIVING entity (not drop)", "SIDE: SERVER"})
            @Config.RangeInt(min=0, max=25600)
            @Config.SlidingOption
            public int ringsTeleportPowerDraw = 640;
        }

        public static class Mechanics {
            @Config.Name(value="Rings range's radius horizontal")
            @Config.RangeInt(min=1, max=256)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int rangeFlat = 25;
            @Config.Name(value="Rings vertical reach")
            @Config.RangeInt(min=1, max=256)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int rangeVertical = 256;
            @Config.Name(value="Ignore rings check for blocks to replace")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean ignoreObstructionCheck = false;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/stargates", category="stargates")
    @Config.LangKey(value="config.jsg.stargates")
    public static class Stargate {
        @Config.Name(value="Stargate size")
        @Config.Comment(value={"Defines size of stargate's model", "SIDE: SERVER/CLIENT"})
        @Config.RequiresWorldRestart
        public static StargateSizeEnum stargateSize = StargateSizeEnum.MEDIUM;
        @Config.Name(value="Mechanics")
        @Config.Comment(value={"Stargate Mechanics settings"})
        public static Mechanics mechanics = new Mechanics();
        @Config.Name(value="RIG")
        @Config.Comment(value={"Stargate Random Incoming Generator settings"})
        public static RIG rig = new RIG();
        @Config.Name(value="Iris")
        @Config.Comment(value={"Stargate Iris settings"})
        public static Iris iris = new Iris();
        @Config.Name(value="Power")
        @Config.Comment(value={"Stargate Power settings"})
        public static Power power = new Power();
        @Config.Name(value="Visual")
        @Config.Comment(value={"Stargate Video settings"})
        public static Visual visual = new Visual();
        @Config.Name(value="Origins")
        @Config.Comment(value={"Stargate Origins settings"})
        public static PointOfOrigins pointOfOrigins = new PointOfOrigins();
        @Config.Name(value="EventHorizon")
        @Config.Comment(value={"Stargate Event Horizon settings"})
        public static EventHorizon eventHorizon = new EventHorizon();
        @Config.Name(value="AutoClose")
        @Config.Comment(value={"Stargate Auto Close settings"})
        public static AutoCloseConfig autoClose = new AutoCloseConfig();
        @Config.Name(value="OpenTimeLimit")
        @Config.Comment(value={"Stargate Open Time Limit settings"})
        public static OpenLimitConfig openLimit = new OpenLimitConfig();

        public static class RIG {
            @Config.Name(value="Enable random incoming wormholes")
            @Config.Comment(value={"Enable random incoming wormholes generator", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"})
            public boolean enableRandomIncoming = true;
            @Config.Name(value="Chance of spawning")
            @Config.Comment(value={"10 = 1%", "SIDE: SERVER"})
            @Config.RangeInt(min=1, max=100)
            @Config.SlidingOption
            public int chance = 1;
            @Config.Name(value="Entities to spawn")
            @Config.Comment(value={"Format: \"modid:entityid\", for example: ", "\"minecraft:zombie\"", "\"minecraft:creeper\"", "SIDE: SERVER"})
            public String[] entitiesToSpawn = new String[]{"minecraft:zombie", "minecraft:skeleton"};
        }

        public static class OpenLimitConfig {
            @Config.Name(value="Maximum seconds of gate should be open")
            @Config.Comment(value={"(in seconds (2280 = 38 minutes))", "SIDE: SERVER"})
            @Config.RangeInt(min=5, max=3000)
            @Config.SlidingOption
            public int maxOpenedSeconds = 240;
            @Config.Name(value="Gate open time limit mode")
            @Config.Comment(value={"What happens after gate's open time reaches limit?", "SIDE: SERVER"})
            public StargateTimeLimitModeEnum maxOpenedWhat = StargateTimeLimitModeEnum.DRAW_MORE_POWER;
            @Config.Name(value="Power draw after opened time limit")
            @Config.RangeInt(min=0, max=50000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int maxOpenedPowerDrawAfterLimit = 10000;
        }

        public static class AutoCloseConfig {
            @Config.Name(value="Autoclose enabled")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean autocloseEnabled = true;
            @Config.Name(value="Seconds to autoclose with no players nearby")
            @Config.RangeInt(min=1, max=300)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int secondsToAutoclose = 5;
        }

        public static class EventHorizon {
            @Config.Name(value="Disable animated Event Horizon")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Changing this option will require you to reload resources manually.", "Just restart your game", "SIDE: CLIENT"})
            public boolean disableAnimatedEventHorizon = false;
            @Config.Name(value="Enable wrong side killing")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean wrongSideKilling = true;
            @Config.Name(value="Unstable Event Horizon chance of death")
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public float ehDeathChance = 0.07f;
            @Config.Name(value="Disable new kawoosh model (from 4.11.0.0)")
            @Config.RequiresMcRestart
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean disableNewKawoosh = false;
            @Config.Name(value="Kawoosh invincible blocks")
            @Config.Comment(value={"Format: \"modid:blockid[:meta/*]\", for example: ", "\"minecraft:wool:7\"", "\"minecraft:stone\"", "\"minecraft:concrete:*\"", "SIDE: SERVER"})
            public String[] kawooshInvincibleBlocks = new String[]{"minecraft:snow_layer:*", "minecraft:rail:*", "minecraft:golden_rail:*", "minecraft:detector_rail:*", "minecraft:activator_rail:*", "minecraft:carpet:*", "minecraft:stone_pressure_plate:*", "minecraft:wooden_pressure_plate:*", "minecraft:light_weighted_pressure_plate:*", "minecraft:heavy_weighted_pressure_plate:*"};
            @Config.Name(value="Render EHs even if they are not rendering")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean renderEHifTheyNot = true;
        }

        public static class PointOfOrigins {
            @Config.Name(value="Enable different Point Of Origins for MW gate")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean enableDiffOrigins = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Custom added points of origin")
            @Config.Comment(value={"Specifies Point Of Origins that were added by any resource pack.", "This options is required to load all models of added origins!", "Format: \"id:name\", for example: ", "\"6:Tollan\"", "\"7:P4X-256\"", "!DO NOT CHANGE ANYTHING IF YOU DON'T KNOW WHAT ARE YOU DOING!", "SIDE: CLIENT/SERVER"})
            public String[] additionalOrigins = new String[0];
        }

        public static class Visual {
            @Config.Name(value="Temperature threshold for frosty overlay")
            @Config.Comment(value={"Below this biome temperature the gate will receive frosty texture.", "Set to negative value to disable.", "SIDE: CLIENT"})
            @Config.RangeDouble(min=0.0, max=5.0)
            @Config.SlidingOption
            public float frostyTemperatureThreshold = 0.1f;
            @Config.Name(value="Biome overlay biome matches")
            @Config.Comment(value={"This check comes last (after block is directly under sky (except Nether) and temperature is high enough).", "You can disable the temperature check by setting it to a negative value.", "Format: \"modid:biomename\", for example: ", "\"minecraft:dark_forest\"", "\"minecraft:forest\"", "SIDE: SERVER/CLIENT"})
            public Map<String, String[]> biomeMatches = new HashMap<String, String[]>(){
                {
                    this.put(BiomeOverlayEnum.NORMAL.toString(), new String[0]);
                    this.put(BiomeOverlayEnum.FROST.toString(), new String[0]);
                    this.put(BiomeOverlayEnum.MOSSY.toString(), new String[]{"minecraft:jungle", "minecraft:jungle_hills", "minecraft:jungle_edge", "minecraft:mutated_jungle", "minecraft:mutated_jungle_edge"});
                    this.put(BiomeOverlayEnum.AGED.toString(), new String[0]);
                    this.put(BiomeOverlayEnum.SOOTY.toString(), new String[]{"minecraft:hell"});
                }
            };
            @Config.Name(value="Biome overlay override blocks")
            @Config.Comment(value={"Format: \"modid:blockid[:meta]\", for example: ", "\"minecraft:wool:7\"", "\"minecraft:stone\"", "SIDE: SERVER/CLIENT"})
            public Map<String, String[]> biomeOverrideBlocks = new HashMap<String, String[]>(){
                {
                    this.put(BiomeOverlayEnum.NORMAL.toString(), new String[]{"minecraft:stone"});
                    this.put(BiomeOverlayEnum.FROST.toString(), new String[]{"minecraft:ice"});
                    this.put(BiomeOverlayEnum.MOSSY.toString(), new String[]{"minecraft:vine"});
                    this.put(BiomeOverlayEnum.AGED.toString(), new String[]{"minecraft:cobblestone"});
                    this.put(BiomeOverlayEnum.SOOTY.toString(), new String[]{"minecraft:coal_block"});
                }
            };
            @Config.Name(value="Allow incoming animations")
            @Config.Comment(value={"If the incoming animations of gates generate issues, set it to false", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"})
            public boolean allowIncomingAnimations = true;
            @Config.Name(value="Faster MilkyWay and Universe gates computer dial")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Speed up dialing with computer on MW and UNI gates", "SIDE: SERVER/CLIENT"})
            public boolean fasterMWGateDial = false;
            @Config.Name(value="Enable fast dialing of gates")
            @Config.Comment(value={"Enable fast dialing on gates by default", "THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER/CLIENT"})
            public boolean enableFastDialing = false;
            @Config.Name(value="Render not placed blocks of s stargate")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean renderStargateNotPlaced = true;
        }

        public static class Power {
            @Config.Name(value="Stargate's internal buffer size")
            @Config.RangeInt(min=4608)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int stargateEnergyStorage = 71280000;
            @Config.Name(value="Stargate's max power throughput")
            @Config.RangeInt(min=1, max=500000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int stargateMaxEnergyTransfer = 26360;
            @Config.Name(value="Stargate wormhole open power draw")
            @Config.RangeInt(min=0, max=500000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int openingBlockToEnergyRatio = 4608;
            @Config.Name(value="Stargate wormhole sustain power draw")
            @Config.RangeInt(min=0, max=50)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int keepAliveBlockToEnergyRatioPerTick = 2;
            @Config.Name(value="Stargate instability threshold")
            @Config.Comment(value={"Seconds of energy left before gate becomes unstable", "SIDE: SERVER"})
            @Config.RangeInt(min=1, max=120)
            @Config.SlidingOption
            public int instabilitySeconds = 20;
            @Config.Name(value="Orlin's gate energy multiplier")
            @Config.RangeDouble(min=0.0, max=100.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public double stargateOrlinEnergyMul = 2.0;
            @Config.Name(value="Universe gate energy multiplier")
            @Config.RangeDouble(min=0.0, max=100.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public double stargateUniverseEnergyMul = 1.5;
            @Config.Name(value="Capacitors supported by Universe gates")
            @Config.Comment(value={"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER/CLIENT"})
            @Config.RangeInt(min=0, max=3)
            @Config.SlidingOption
            public int universeCapacitors = 0;
            @Config.Name(value="Stargate eight symbols address power mul")
            @Config.Comment(value={"Specifies the multiplier of power needed to keep the gate alive", "when 8-symbols address is dialed", "SIDE: SERVER"})
            @Config.RangeDouble(min=0.0, max=100.0)
            @Config.SlidingOption
            public float eightSymbolAddressMul = 1.3f;
            @Config.Name(value="Stargate nine symbols address power mul")
            @Config.Comment(value={"Specifies the multiplier of power needed to keep the gate alive", "when 9-symbols address is dialed", "SIDE: SERVER"})
            @Config.RangeDouble(min=0.0, max=100.0)
            @Config.SlidingOption
            public float nineSymbolAddressMul = 1.7f;
        }

        public static class Iris {
            @Config.Name(value="Iris kills at destination")
            @Config.Comment(value={"If set to 'false' player get killed by iris on entering event horizon", "SIDE: SERVER"})
            public boolean killAtDestination = true;
            @Config.Name(value="Titanium iris durability")
            @Config.Comment(value={"Durability of Titanium iris", "set it to 0, if u want to make it unbreakable", "SIDE: SERVER/CLIENT"})
            @Config.RangeInt(min=0, max=50000)
            @Config.SlidingOption
            public int titaniumIrisDurability = 500;
            @Config.Name(value="Trinium iris durability")
            @Config.Comment(value={"Durability of Trinium iris", "set it to 0, if u want to make it unbreakable", "SIDE: SERVER/CLIENT"})
            @Config.RangeInt(min=0, max=50000)
            @Config.SlidingOption
            public int triniumIrisDurability = 1000;
            @Config.Name(value="Shield power draw")
            @Config.Comment(value={"Energy/tick used for make shield closed", "SIDE: SERVER"})
            @Config.RangeInt(min=0, max=500000)
            @Config.SlidingOption
            public int shieldPowerDraw = 500;
            @Config.Name(value="Allow creative bypass")
            @Config.Comment(value={"Set it to true, if u want to bypass", "shield/iris damage by creative gamemode", "SIDE: SERVER"})
            public boolean allowCreative = false;
            @Config.Name(value="Maximum iris code length")
            @Config.RangeInt(min=0, max=32)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int irisCodeLength = 9;
            @Config.Name(value="Can iris destroy blocks")
            @Config.Comment(value={"SIDE: SERVER"})
            public boolean irisDestroysBlocks = false;
            @Config.Name(value="Unbreaking chance per level")
            @Config.Comment(value={"0 - disables unbreaking on iris", "100 - unbreaking makes iris unbreakable", "SIDE: SERVER"})
            @Config.RangeInt(min=0, max=100)
            @Config.SlidingOption
            public int unbreakingChance = 10;
            @Config.Name(value="Enable iris overheat collapse")
            @Config.Comment(value={"Should iris break when its overheated?", "SIDE: SERVER"})
            public boolean enableIrisOverHeatCollapse = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Max titanium iris heat")
            @Config.RangeDouble(min=0.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public double irisTitaniumMaxHeat = 1668.0;
            @Config.RequiresMcRestart
            @Config.Name(value="Max trinium iris heat")
            @Config.RangeDouble(min=0.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public double irisTriniumMaxHeat = 3336.0;
        }

        public static class Mechanics {
            @Config.Name(value="Enable burried state for gates")
            @Config.Comment(value={"THIS OPTION CAN BE OVERRIDE BY SETTING IT IN STARGATE GUI", "SIDE: SERVER"})
            public boolean enableBurriedState = true;
            @Config.Name(value="Orlin's gate max open count")
            @Config.RangeInt(min=0, max=15000)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public int stargateOrlinMaxOpenCount = 2;
            @Config.Name(value="Universe dialer nearby radius")
            @Config.RangeInt(min=5)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int universeGateNearbyReach = 1024;
            @Config.Name(value="Enable gate overheat with explosion")
            @Config.Comment(value={"Should gate explode when its overheated?", "This method is not implemented yet!", "SIDE: SERVER"})
            public boolean enableGateOverHeatExplosion = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Max stargate heat")
            @Config.RangeDouble(min=0.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public double gateMaxHeat = 83400.0;
            @Config.Name(value="Chance of lighting strike that charge a gate")
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public float lightingBoldChance = 5.0E-4f;
            @Config.Name(value="Connect to dialing gate")
            @Config.Comment(value={"If target gate is dialing and this option is set to true,", "the target gate will stop dialing and open incoming wormhole.", "If this is set to false and the dialed gate dialing address,", "the connection will not established.", "If it cause issues, set it to false.", "SIDE: SERVER"})
            public boolean allowConnectToDialing = true;
            @Config.Name(value="Use 8 chevrons between MW and PG gates")
            @Config.Comment(value={"Change this to true, if you want to use 8 chevrons between pegasus and milkyway gates", "SIDE: SERVER"})
            public boolean pegAndMilkUseEightChevrons = true;
            @Config.Name(value="Need only 7 symbols between Uni gates")
            @Config.Comment(value={"If you want to dial UNI-UNI only with seven symbols (interdimensional for example), set this to true", "SIDE: SERVER"})
            public boolean useStrictSevenSymbolsUniGate = false;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/zpm", category="zpm")
    @Config.LangKey(value="config.jsg.zpm")
    public static class ZPM {
        @Config.Name(value="Power")
        @Config.Comment(value={"ZPM Power settings"})
        public static Power power = new Power();

        public static class Power {
            @Config.Name(value="ZPM capacity (RF)")
            @Config.Comment(value={"SIDE: SERVER/CLIENT"})
            public double zpmCapacity = 4.398046511104E12;
            @Config.Name(value="ZPMHub's max power throughput")
            @Config.RangeInt(min=1, max=1043600)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int zpmHubMaxEnergyTransfer = 104360;
        }
    }

    @Config(modid="jsg", name="jsg/jsgConfig_3.1/general")
    @Config.LangKey(value="config.jsg.general")
    public static class General {
        @Config.Name(value="Check for updates")
        @Config.Comment(value={"Should JSG check for update on startup?", "SIDE: CLIENT"})
        public static boolean enableAutoUpdater = true;
        @Config.Name(value="AGS path")
        @Config.Comment(value={"The pastebin of AGS (used in /ags command)", "SIDE: SERVER"})
        public static String agsPath = "pastebin run pAqHB264";
        @Config.Name(value="Audio")
        @Config.Comment(value={"General Audio settings"})
        public static Audio audio = new Audio();
        @Config.Name(value="Visual")
        @Config.Comment(value={"General Video settings"})
        public static Visual visual = new Visual();
        @Config.Name(value="Integration")
        @Config.Comment(value={"Integration settings"})
        public static Integration integration = new Integration();
        @Config.Name(value="Debug")
        @Config.Comment(value={"Debug settings"})
        public static Debug debug = new Debug();
        @Config.Name(value="Advancements")
        @Config.Comment(value={"Advancements settings"})
        public static AdvancementsConfig advancementsConfig = new AdvancementsConfig();
        @Config.Name(value="Countdown")
        @Config.Comment(value={"Countdown settings"})
        public static CountDownConfig countdownConfig = new CountDownConfig();
        @Config.Name(value="MainMenu")
        @Config.Comment(value={"Main Menu settings"})
        public static MainMenuConfig mainMenuConfig = new MainMenuConfig();
        @Config.Name(value="Development")
        @Config.Comment(value={"Developer settings"})
        public static DevConfig devConfig = new DevConfig();

        public static class MainMenuConfig {
            @Config.RequiresMcRestart
            @Config.Name(value="Disable JSG main menu")
            @Config.Comment(value={"Disables showing custom main menu", "WARNING! - Requires reloading!", "SIDE: CLIENT"})
            public boolean disableJSGMainMenu = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Enable Tau'ri logo on startup")
            @Config.Comment(value={"WARNING! - Requires reloading!", "SIDE: CLIENT"})
            public boolean enableLogo = true;
            @Config.Name(value="Enable debug mode")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean debugMode = false;
            @Config.Name(value="Play music in main menu")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean playMusic = true;
            @Config.Name(value="Enable sync with minecraft ticks")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean syncEnabled = false;
            @Config.Name(value="Enable changing gate type")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean enableGateChanging = true;
            @Config.Name(value="Enable loading music")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean loadingMusic = true;
        }

        public static class DevConfig {
            @Config.Name(value="Dev mode")
            public boolean enableDevMode = false;
            @Config.Name(value="t1")
            public boolean t1 = false;
            @Config.Name(value="x")
            public float x = 0.0f;
            @Config.Name(value="y")
            public float y = 0.0f;
            @Config.Name(value="z")
            public float z = 0.0f;
            @Config.Name(value="x2")
            public float x2 = 0.0f;
            @Config.Name(value="y2")
            public float y2 = 0.0f;
            @Config.Name(value="z2")
            public float z2 = 0.0f;
            @Config.Name(value="s")
            public float s = 1.0f;
            @Config.Name(value="sz")
            public float sz = 0.0f;
            @Config.Name(value="yz")
            public float yz = 0.0f;
            @Config.Name(value="tz")
            public float tz = 0.0f;
        }

        public static class CountDownConfig {
            @Config.Name(value="Delay after zero-time (seconds)")
            @Config.RangeInt(min=0, max=60)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int zeroDelay = 5;
            @Config.Name(value="Delay to start dialing after countdown start (seconds)")
            @Config.RangeInt(min=0, max=60)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int dialStartDelay = 5;
        }

        public static class AdvancementsConfig {
            @Config.Name(value="Ranged Advancements radius")
            @Config.Comment(value={"Players in this radius around triggered pos will get Advancement.", "SIDE: SERVER"})
            @Config.RangeInt(min=0, max=100)
            @Config.SlidingOption
            public int radius = 25;
        }

        public static class Integration {
            @Config.RequiresMcRestart
            @Config.Name(value="Enable Tinkers' Construct integration")
            @Config.Comment(value={"WARNING! - Requires reloading!", "SIDE: SERVER/CLIENT"})
            public boolean tConstructIntegration = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Enable Open Computers integration")
            @Config.Comment(value={"WARNING! - Requires reloading!", "SIDE: SERVER/CLIENT"})
            public boolean ocIntegration = true;
            @Config.Name(value="OC wireless network range (in blocks)")
            @Config.RangeInt(min=0, max=100)
            @Config.SlidingOption
            @Config.Comment(value={"SIDE: SERVER"})
            public int ocIntegrationWirelessRange = 20;
            @Config.RequiresMcRestart
            @Config.Name(value="Enable Thermal Expansion integration")
            @Config.Comment(value={"WARNING! - Requires reloading!", "SIDE: SERVER/CLIENT"})
            public boolean tExpansionIntegration = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Enable Fluid Logged API integration")
            @Config.Comment(value={"WARNING! - Requires reloading!", "SIDE: SERVER/CLIENT"})
            public boolean flapiIntegration = true;
        }

        public static class Debug {
            @Config.Name(value="Check gate merge")
            @Config.Comment(value={"Check if gate is merged?", "SIDE: SERVER"})
            public boolean checkGateMerge = true;
            @Config.Name(value="Render bounding boxes")
            @Config.Comment(value={"Render bounding boxes of stargates?", "SIDE: CLIENT"})
            public boolean renderBoundingBoxes = false;
            @Config.Name(value="Render whole kawoosh bounding box")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean renderWholeKawooshBoundingBox = false;
            @Config.Name(value="Render invisible blocks")
            @Config.Comment(value={"Should render iris/stargate merged/rings barricade blocks?", "SIDE: CLIENT"})
            public boolean renderInvisibleBlocks = false;
            @Config.Name(value="Show loading textures in log")
            @Config.Comment(value={"Should log every single texture while loading the mod?", "SIDE: SERVER/CLIENT"})
            public boolean logTexturesLoading = false;
            @Config.Name(value="Log debug messages as info")
            @Config.Comment(value={"If debug console not working, should display debug as info?", "SIDE: SERVER/CLIENT"})
            public boolean logDebugAsInfo = false;
        }

        public static class Visual {
            @Config.Name(value="Notebook page Glyph transparency")
            @Config.Comment(value={"Specifies transparency of glyphs on notebook page", "SIDE: CLIENT"})
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            public double glyphTransparency = 0.75;
            @Config.Name(value="Notebook Page offset")
            @Config.Comment(value={"Greater values render the Page more to the center of the screen, smaller render it closer to the borders.", "0 - for standard 16:9 (default),", "0.2 - for 4:3.", "SIDE: CLIENT"})
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            public float pageNarrowing = 0.0f;
            @Config.Name(value="Render emissive textures")
            @Config.Comment(value={"Render light of some textures.", "Disable this if it causes lags.", "SIDE: CLIENT"})
            public boolean renderEmissive = true;
            @Config.Name(value="Change title to w/ JSG")
            @Config.Comment(value={"SIDE: CLIENT"})
            public boolean changeTitle = true;
            @Config.Name(value="Temperature unit")
            @Config.Comment(value={"Specifies what unit will be used to display temperatures", "SIDE: CLIENT"})
            public TemperatureHelper.EnumTemperatureUnit temperatureUnit = TemperatureHelper.EnumTemperatureUnit.CELSIUS;
        }

        public static class Audio {
            @Config.Name(value="JSG volume")
            @Config.Comment(value={"Specifies volume of sounds from JSG", "SIDE: CLIENT"})
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.SlidingOption
            public float volume = 1.0f;
        }
    }
}

