/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.command.stargate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import tauri.dev.jsg.worldgen.structures.EnumStructures;
import tauri.dev.jsg.worldgen.util.JSGWorldTopBlock;

public class CommandStructureSpawn
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "jsggeneratestructure";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/jsggeneratestructure <structure name> <x> <z> [dimId]";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("Use: " + this.func_71518_a(sender), new Object[0]);
        }
        World world = sender.func_130014_f_();
        int dimId = world.field_73011_w.getDimension();
        BlockPos pos = sender.func_180425_c();
        try {
            EnumStructures structure = EnumStructures.getStructureByName(args[0]);
            if (structure == null) {
                throw new WrongUsageException("Structure whit that name not found!", new Object[0]);
            }
            if (args.length >= 45) {
                dimId = Integer.parseInt(args[3]);
            }
            if (!DimensionManager.isDimensionRegistered((int)dimId)) {
                throw new WrongUsageException("Dimension not found!", new Object[0]);
            }
            double x = CommandStructureSpawn.func_175770_a((double)pos.func_177958_n(), (String)args[1], (boolean)false).func_179628_a();
            double z = CommandStructureSpawn.func_175770_a((double)pos.func_177952_p(), (String)args[2], (boolean)false).func_179628_a();
            JSGWorldTopBlock topBlock = JSGWorldTopBlock.getTopBlock((World)server.func_71218_a(dimId), (int)Math.round(x), (int)Math.round(z), structure.getActualStructure((int)dimId).airUp, dimId);
            if (topBlock == null) {
                throw new CommandException("Can not get top block!", new Object[0]);
            }
            structure.getActualStructure(dimId).generateStructure(world, new BlockPos(x, (double)topBlock.y, z), new Random(), server.func_71218_a(dimId));
        }
        catch (Exception e) {
            throw new WrongUsageException("Use: " + this.func_71518_a(sender), new Object[0]);
        }
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandStructureSpawn.func_175762_a((String[])args, EnumStructures.getAllStructureNames());
        }
        if (args.length == 4) {
            return CommandStructureSpawn.func_175762_a((String[])args, Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        }
        return args.length > 1 && args.length <= 3 ? CommandStructureSpawn.func_175771_a((String[])args, (int)1, (BlockPos)targetPos) : Collections.emptyList();
    }
}

