/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.command.stargate;

import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.notebook.PageNotebookItem;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateNetwork;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;

public class CommandStargateQuery
extends CommandBase {
    public String func_71517_b() {
        return "sgquery";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/sgquery";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        AxisAlignedBB queryBox = null;
        SymbolTypeEnum symbolType = null;
        if (args.length >= 1 && args[0].equals("help")) {
            throw new WrongUsageException("commands.sgquery.usage", new Object[0]);
        }
        boolean checkDim = false;
        int dimId = 0;
        int idCheck = -1;
        boolean givePage = false;
        int givePageCount = 1;
        try {
            if (args.length >= 6) {
                BlockPos pos = sender.func_180425_c();
                int x1 = (int)CommandStargateQuery.func_175770_a((double)pos.func_177958_n(), (String)args[0], (boolean)false).func_179628_a();
                int y1 = (int)CommandStargateQuery.func_175767_a((double)pos.func_177956_o(), (String)args[1], (int)0, (int)255, (boolean)false).func_179628_a();
                int z1 = (int)CommandStargateQuery.func_175770_a((double)pos.func_177952_p(), (String)args[2], (boolean)false).func_179628_a();
                int x2 = (int)CommandStargateQuery.func_175770_a((double)pos.func_177958_n(), (String)args[3], (boolean)false).func_179628_a();
                int y2 = (int)CommandStargateQuery.func_175767_a((double)pos.func_177956_o(), (String)args[4], (int)0, (int)255, (boolean)false).func_179628_a();
                int z2 = (int)CommandStargateQuery.func_175770_a((double)pos.func_177952_p(), (String)args[5], (boolean)false).func_179628_a();
                BlockPos sPos = new BlockPos(x1, y1, z1);
                BlockPos tPos = new BlockPos(x2, y2, z2);
                queryBox = new AxisAlignedBB(sPos, tPos);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("dim=")) {
                    checkDim = true;
                    dimId = Integer.valueOf(args[i].substring(4));
                    continue;
                }
                if (args[i].startsWith("map=")) {
                    symbolType = SymbolTypeEnum.valueOf(args[i].substring(4).toUpperCase());
                    continue;
                }
                if (args[i].startsWith("id=")) {
                    idCheck = Integer.valueOf(args[i].substring(3));
                    continue;
                }
                if (!args[i].toLowerCase().startsWith("givepage=")) continue;
                if (args[i].length() > 8) {
                    try {
                        givePageCount = Integer.valueOf(args[i].substring(9));
                    }
                    catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                        throw new WrongUsageException("commands.sgquery.wrong_quantity", new Object[0]);
                    }
                }
                givePage = true;
            }
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("commands.sgquery.number_expected", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new WrongUsageException("commands.sgquery.no_map", new Object[0]);
        }
        String infoString = "[dim=" + (checkDim ? Integer.valueOf(dimId) : "any") + ", ";
        infoString = infoString + "map=" + (symbolType != null ? symbolType.toString() : "no") + ", ";
        infoString = infoString + "id=" + (idCheck != -1 ? Integer.valueOf(idCheck) : "any") + ", ";
        infoString = infoString + "box=" + (queryBox != null ? queryBox.toString() : "any") + "]:";
        CommandStargateQuery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.sgquery.stargates", (Object[])new Object[]{TextFormatting.AQUA + infoString});
        StargateNetwork network = StargateNetwork.get(sender.func_130014_f_());
        Map<StargateAddress, StargatePos> map = network.getMap().get(symbolType != null ? symbolType : SymbolTypeEnum.MILKYWAY);
        int id = 1;
        StargateAddress selectedAddress = null;
        StargatePos selectedStargatePos = null;
        for (StargateAddress address : map.keySet()) {
            if (checkDim && map.get((Object)address).dimensionID != dimId) continue;
            BlockPos pos = map.get((Object)address).gatePos;
            if (queryBox != null && !queryBox.func_72318_a(new Vec3d((Vec3i)pos))) continue;
            if (idCheck == -1 || id == idCheck) {
                selectedStargatePos = map.get(address);
                selectedAddress = address;
                String gateString = " " + id + ". [";
                gateString = gateString + "x=" + pos.func_177958_n() + ", ";
                gateString = gateString + "y=" + pos.func_177956_o() + ", ";
                gateString = gateString + "z=" + pos.func_177952_p() + ", ";
                gateString = gateString + "dim=" + selectedStargatePos.getWorld().field_73011_w.getDimension() + " (" + selectedStargatePos.getWorld().field_73011_w.func_186058_p().func_186065_b() + ")]";
                if (symbolType != null) {
                    gateString = gateString + ": " + TextFormatting.DARK_GREEN;
                    for (int i = 0; i < 8; ++i) {
                        if (i >= 6) {
                            gateString = gateString + TextFormatting.DARK_PURPLE;
                        }
                        gateString = symbolType == SymbolTypeEnum.UNIVERSE ? gateString + address.get(i).toString() : gateString + address.get(i).localize();
                        if (i >= 7) continue;
                        gateString = gateString + ", ";
                    }
                }
                CommandStargateQuery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)gateString, (Object[])new Object[0]);
                if (symbolType != null && symbolType != SymbolTypeEnum.UNIVERSE) {
                    CommandStargateQuery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"", (Object[])new Object[0]);
                }
            }
            ++id;
        }
        if (givePage) {
            if (idCheck == -1 || selectedAddress == null || selectedStargatePos == null) {
                throw new WrongUsageException("commands.sgquery.wrong_id", new Object[0]);
            }
            if (symbolType == null) {
                throw new WrongUsageException("commands.sgquery.wrong_map", new Object[0]);
            }
            if (!(sender instanceof EntityPlayer)) {
                throw new WrongUsageException("commands.sgquery.wrong_sender", new Object[0]);
            }
            ItemStack stack = new ItemStack((Item)JSGItems.PAGE_NOTEBOOK_ITEM, givePageCount, 1);
            int originId = -1;
            StargateAbstractBaseTile tile = selectedStargatePos.getTileEntity();
            if (tile instanceof StargateClassicBaseTile) {
                originId = ((StargateClassicBaseTile)tile).getOriginId();
            }
            stack.func_77982_d(PageNotebookItem.getCompoundFromAddress(selectedAddress, true, PageNotebookItem.getRegistryPathFromWorld(selectedStargatePos.getWorld(), selectedStargatePos.gatePos), originId));
            ((EntityPlayer)sender).func_191521_c(stack);
            CommandStargateQuery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.sgquery.giving_page", (Object[])new Object[]{sender.func_70005_c_()});
        }
    }
}

