/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.stargate;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.stargate.StargateAbstractBaseBlock;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.stargate.CamoPropertiesHelper;
import tauri.dev.jsg.stargate.EnumMemberVariant;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class StargateClassicBaseBlock
extends StargateAbstractBaseBlock {
    public StargateClassicBaseBlock(String blockName) {
        super(blockName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        StargateClassicBaseTile gateTile = (StargateClassicBaseTile)world.func_175625_s(pos);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        EnumFacing verticalFacing = EnumFacing.SOUTH;
        if (!world.field_72995_K) {
            state = state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)verticalFacing).func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true));
            world.func_175656_a(pos, state);
            gateTile.updateFacing(facing, verticalFacing, true);
            gateTile.updateMergeState(gateTile.getMergeHelper().checkBlocks((IBlockAccess)world, pos, facing, verticalFacing), facing, verticalFacing);
        }
    }

    @Override
    protected void showGateInfo(EntityPlayer player, EnumHand hand, World world, BlockPos pos) {
        StargateClassicBaseTile tile = (StargateClassicBaseTile)world.func_175625_s(pos);
        if (tile != null && tile.isMerged() && !tile.tryInsertUpgrade(player, hand)) {
            player.openGui((Object)JSG.instance, GuiIdEnum.GUI_STARGATE.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.FACING_HORIZONTAL, JSGProps.FACING_VERTICAL, JSGProps.RENDER_BLOCK});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)JSGProps.RENDER_BLOCK) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176736_b();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return state;
        }
        StargateClassicBaseTile sg = (StargateClassicBaseTile)worldIn.func_175625_s(pos);
        if (sg != null) {
            return state.func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)sg.getFacingVertical());
        }
        return state;
    }

    @Override
    protected IBlockState createMemberState(IBlockState memberState, EnumFacing facing, EnumFacing facingVertical, int meta) {
        return memberState.func_177226_a((IProperty)JSGProps.RENDER_BLOCK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing).func_177226_a((IProperty)JSGProps.FACING_VERTICAL, (Comparable)facingVertical).func_177226_a((IProperty)JSGProps.MEMBER_VARIANT, (Comparable)((Object)EnumMemberVariant.byId(meta >> 3 & 1)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return CamoPropertiesHelper.getStargateBlockBoundingBox(state, access, pos, false);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return CamoPropertiesHelper.getStargateBlockBoundingBox(state, access, pos, true);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }
}

