/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.props;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.props.JSGAbstractProp;
import tauri.dev.jsg.item.props.TRPlatformItem;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.util.main.JSGProps;

public class TRPlatformBlock
extends JSGAbstractProp {
    public static final String BASE = "platform_";
    public static final String END = "_block";
    public static final String BLOCK_NAME = "platform_rings_block";

    public TRPlatformBlock() {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:platform_rings_block");
        this.func_149663_c("jsg:platform_rings_block");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public void func_149666_a(@Nonnull CreativeTabs creativeTabs, @Nonnull NonNullList<ItemStack> items) {
        for (TRPlatformItem.TRPlatformVariants variant : TRPlatformItem.TRPlatformVariants.values()) {
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)JSGProps.PROP_VARIANT, (Comparable)Integer.valueOf(variant.id)))));
        }
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add(JSG.getInProgress());
    }

    public SoundEventEnum getPlatformSound(boolean closing) {
        if (closing) {
            return this.getPlatform().closingSound;
        }
        return this.getPlatform().openingSound;
    }

    @SideOnly(value=Side.CLIENT)
    public ElementEnum getPlatformModelBase() {
        return this.getPlatform().modelBase;
    }

    @SideOnly(value=Side.CLIENT)
    public ElementEnum getPlatformModelMoving() {
        return this.getPlatform().modelMoving;
    }

    @SideOnly(value=Side.CLIENT)
    public ElementEnum getPlatformModelToOverlay() {
        return this.getPlatform().modelOverlay;
    }

    public boolean canRenderUnderZero() {
        return this.getPlatform().canRenderUnderZero;
    }

    public BlockPos[] getPattern() {
        return this.getPlatform().pattern;
    }

    public TRPlatformItem.TRPlatformVariants getPlatform() {
        return TRPlatformItem.TRPlatformVariants.byId(this.func_176201_c(this.func_176194_O().func_177621_b()));
    }

    @Override
    public ItemBlock getItemBlock() {
        return new TRPlatformItem(this);
    }

    @Override
    public int getAllMetasCount() {
        return TRPlatformItem.TRPlatformVariants.values().length;
    }

    @Override
    public String getBlockName() {
        return BLOCK_NAME;
    }
}

