/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.props;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.gui.AncientSignEditGui;
import tauri.dev.jsg.renderer.props.AncientSignRenderer;
import tauri.dev.jsg.tileentity.props.AncientSignTile;
import tauri.dev.jsg.util.JSGColorUtil;
import tauri.dev.jsg.util.main.JSGProps;

public class AncientSignBlock
extends JSGBlock {
    private static final String BLOCK_NAME = "ancient_sign";
    protected static final AxisAlignedBB SIGN_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.025, 1.0, 1.0);
    protected static final AxisAlignedBB SIGN_WEST_AABB = new AxisAlignedBB(0.975, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SIGN_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.025);
    protected static final AxisAlignedBB SIGN_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.975, 1.0, 1.0, 1.0);

    public AncientSignBlock() {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:ancient_sign");
        this.func_149663_c("jsg.ancient_sign");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_PROPS_CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149715_a(0.33333334f);
        this.func_149711_c(2.5f);
        this.func_149752_b(15.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new AncientSignTile();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return AncientSignTile.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<? extends TileEntity> getTESR() {
        return new AncientSignRenderer();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return super.func_176198_a(worldIn, pos, side) && JSGProps.FACING_HORIZONTAL.func_177700_c().contains(side);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.FACING_HORIZONTAL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)) {
            default: {
                return SIGN_NORTH_AABB;
            }
            case SOUTH: {
                return SIGN_SOUTH_AABB;
            }
            case WEST: {
                return SIGN_WEST_AABB;
            }
            case EAST: 
        }
        return SIGN_EAST_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        switch ((EnumFacing)blockState.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)) {
            default: {
                return SIGN_NORTH_AABB;
            }
            case SOUTH: {
                return SIGN_SOUTH_AABB;
            }
            case WEST: {
                return SIGN_WEST_AABB;
            }
            case EAST: 
        }
        return SIGN_EAST_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
        if (!worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_185904_a().func_76220_a()) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public static boolean interact(@Nonnull World worldIn, @Nonnull BlockPos blockPos, @Nonnull EntityLivingBase entity, @Nullable EnumHand hand) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        TileEntity tile = worldIn.func_175625_s(blockPos);
        if (tile instanceof AncientSignTile) {
            ItemStack stack;
            AncientSignTile casted = (AncientSignTile)tile;
            if (hand != null && (stack = player.func_184586_b(hand)).func_77973_b() instanceof ItemDye) {
                int newColor;
                if (!worldIn.field_72995_K && (newColor = JSGColorUtil.blendColors(casted.color, JSGColorUtil.getColorFromDyeItem(stack), 0.25f)) != casted.color) {
                    casted.color = newColor;
                    tile.func_70296_d();
                    if (!player.func_184812_l_() && !player.func_175149_v()) {
                        stack.func_190918_g(1);
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                    }
                }
                return true;
            }
            if (worldIn.field_72995_K) {
                AncientSignBlock.displayGui(casted);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private static void displayGui(AncientSignTile tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new AncientSignEditGui(tile));
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tile;
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()) != null && compound.func_74764_b("BlockEntityTag") && (tile = world.func_175625_s(pos)) instanceof AncientSignTile) {
            AncientSignTile casted = (AncientSignTile)tile;
            NBTTagCompound c = compound.func_74775_l("BlockEntityTag");
            casted.fromItemStack(c);
            casted.func_70296_d();
            return;
        }
        AncientSignBlock.interact(world, pos, placer, null);
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        return AncientSignBlock.interact(worldIn, pos, (EntityLivingBase)playerIn, hand);
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        return !this.hasInvalidNeighbor(worldIn, pos) && super.func_176196_c(worldIn, pos);
    }

    protected boolean hasInvalidNeighbor(World worldIn, BlockPos pos) {
        return this.isInvalidNeighbor(worldIn, pos, EnumFacing.NORTH) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.SOUTH) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.WEST) || this.isInvalidNeighbor(worldIn, pos, EnumFacing.EAST);
    }

    protected boolean isInvalidNeighbor(World worldIn, BlockPos pos, EnumFacing facing) {
        return worldIn.func_180495_p(pos.func_177972_a(facing)).func_185904_a() == Material.field_151570_A;
    }
}

