/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.machine.JSGMachineBlock;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.item.machine.MachineItemBlock;
import tauri.dev.jsg.renderer.machine.AssemblerRenderer;
import tauri.dev.jsg.tileentity.machine.AssemblerTile;
import tauri.dev.jsg.util.JSGAxisAlignedBB;

public class AssemblerBlock
extends JSGMachineBlock {
    public static final String BLOCK_NAME = "assembler_machine_block";
    public static final int MAX_ENERGY = 9000000;
    public static final int MAX_ENERGY_TRANSFER = 20000;

    public AssemblerBlock() {
        super(BLOCK_NAME);
    }

    @Override
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new AssemblerTile();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return AssemblerTile.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<? extends TileEntity> getTESR() {
        return new AssemblerRenderer();
    }

    @Override
    protected void showGui(EntityPlayer player, EnumHand hand, World world, BlockPos pos) {
        player.openGui((Object)JSG.instance, GuiIdEnum.GUI_ASSEMBLER.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        AssemblerTile tile;
        if (!world.field_72995_K && (tile = (AssemblerTile)world.func_175625_s(pos)) != null) {
            tile.onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public ItemBlock getItemBlock() {
        return new MachineItemBlock(this, BLOCK_NAME, 9000000);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new JSGAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new JSGAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8, 1.0);
    }

    @Override
    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean renderHighlight(IBlockState state) {
        return false;
    }
}

