/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.energy.capacitor;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGAbstractCustomItemBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.item.energy.CapacitorItemBlock;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.power.stargate.StargateItemEnergyStorage;
import tauri.dev.jsg.tileentity.energy.CapacitorTile;
import tauri.dev.jsg.util.ItemHandlerHelper;
import tauri.dev.jsg.util.main.JSGProps;

public class CapacitorBlock
extends JSGAbstractCustomItemBlock {
    public static final String BLOCK_NAME = "capacitor_block";

    public CapacitorBlock(boolean registered) {
        super(Material.field_151573_f);
        if (!registered) {
            this.setRegistryName("jsg:capacitor_block");
            this.func_149663_c("jsg.capacitor_block");
        }
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_ENERGY_CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.FACING_HORIZONTAL, JSGProps.LEVEL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        CapacitorTile capTile = (CapacitorTile)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)JSGProps.LEVEL, (Comparable)Integer.valueOf(capTile.getPowerLevel()));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            player.openGui((Object)JSG.instance, GuiIdEnum.GUI_CAPACITOR.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return !player.func_70093_af();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        state = state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing);
        world.func_175656_a(pos, state);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        StargateAbstractEnergyStorage capacitorEnergyStorage = (StargateAbstractEnergyStorage)((Object)world.func_175625_s(pos).getCapability(CapabilityEnergy.ENERGY, null));
        capacitorEnergyStorage.setEnergyStored(energyStorage.getEnergyStored());
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        StargateAbstractEnergyStorage capacitorEnergyStorage = (StargateAbstractEnergyStorage)((Object)world.func_175625_s(pos).getCapability(CapabilityEnergy.ENERGY, null));
        ItemStack stack = new ItemStack((Block)this);
        ((StargateItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).setEnergyStored(capacitorEnergyStorage.getEnergyStored());
        return Arrays.asList(stack);
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        CapacitorTile tile;
        if (!world.field_72995_K && (tile = (CapacitorTile)world.func_175625_s(pos)) != null) {
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return CapacitorTile.class;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new CapacitorTile();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new CapacitorItemBlock(this, false);
    }
}

