/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.energy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.block.JSGAbstractCustomItemBlock;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.item.energy.ZPMItemBlock;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;
import tauri.dev.jsg.power.zpm.ZPMEnergyStorage;
import tauri.dev.jsg.renderer.zpm.ZPMRenderer;
import tauri.dev.jsg.tileentity.energy.ZPMTile;

public class ZPMBlock
extends JSGAbstractCustomItemBlock {
    public static final String BLOCK_NAME = "zpm";

    public ZPMBlock(boolean registered) {
        super(Material.field_151592_s);
        if (!registered) {
            this.setRegistryName("jsg:zpm");
            this.func_149663_c("jsg.zpm");
        }
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_ENERGY_CREATIVE_TAB);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, ItemStack stack) {
        IEnergyStorageZPM energyStorage = (IEnergyStorageZPM)stack.getCapability(CapabilityEnergyZPM.ENERGY, null);
        ZPMEnergyStorage zpmStorage = (ZPMEnergyStorage)Objects.requireNonNull(world.func_175625_s(pos)).getCapability(CapabilityEnergyZPM.ENERGY, null);
        if (energyStorage != null) {
            Objects.requireNonNull(zpmStorage).setEnergyStored(energyStorage.getEnergyStored());
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ZPMEnergyStorage capacitorEnergyStorage = (ZPMEnergyStorage)world.func_175625_s(pos).getCapability(CapabilityEnergyZPM.ENERGY, null);
        ItemStack stack = new ItemStack((Block)this);
        ((ZPMEnergyStorage)stack.getCapability(CapabilityEnergyZPM.ENERGY, null)).setEnergyStored(capacitorEnergyStorage.getEnergyStored());
        return Collections.singletonList(stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return ZPMTile.class;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ZPMTile();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ZPMItemBlock(this, false);
    }

    @Override
    public boolean renderHighlight(IBlockState blockState) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<? extends TileEntity> getTESR() {
        return new ZPMRenderer();
    }
}

