/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.dialhomedevice;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.ItemHandlerHelper;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class DHDAbstractBlock
extends JSGBlock {
    public static final BlockMatcher SNOW_MATCHER = BlockMatcher.func_177642_a((Block)Blocks.field_150431_aC);

    public DHDAbstractBlock(String blockName) {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:" + blockName);
        this.func_149663_c("jsg." + blockName);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_GATES_CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)JSGProps.SNOWY, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            int facing = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            world.func_180501_a(pos, state.func_177226_a((IProperty)JSGProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(facing)), 3);
            DHDAbstractTile dhdTile = (DHDAbstractTile)world.func_175625_s(pos);
            dhdTile.updateLinkStatus(world, pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.ROTATION_HORIZONTAL, JSGProps.SNOWY});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)JSGProps.ROTATION_HORIZONTAL);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)JSGProps.SNOWY, (Comparable)Boolean.valueOf(DHDAbstractBlock.isSnowAroundBlock(world, pos)));
    }

    public static boolean isSnowAroundBlock(IBlockAccess world, BlockPos inPos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos pos = inPos.func_177972_a(facing);
            if (SNOW_MATCHER.apply(world.func_180495_p(pos))) continue;
            return false;
        }
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DHDAbstractTile tile;
        boolean backActivation;
        EnumFacing dhdFacingOpposite = EnumFacing.func_176731_b((int)Math.round((float)((Integer)state.func_177229_b((IProperty)JSGProps.ROTATION_HORIZONTAL)).intValue() / 4.0f));
        boolean bl = backActivation = facing == dhdFacingOpposite;
        if (!(world.field_72995_K || player.func_70093_af() || !backActivation || FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, null) || (tile = (DHDAbstractTile)world.func_175625_s(pos)).tryInsertUpgrade(player, hand))) {
            player.openGui((Object)JSG.instance, this.getGui().id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return !player.func_70093_af() && backActivation;
    }

    public abstract GuiIdEnum getGui();

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        DHDAbstractTile tile = (DHDAbstractTile)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            StargateClassicBaseTile gateTile = (StargateClassicBaseTile)tile.getLinkedGate((IBlockAccess)world);
            if (gateTile != null) {
                gateTile.setLinkedDHD(null, -1);
            }
            ItemHandlerHelper.dropInventoryItems(world, pos, (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        super.func_180663_b(world, pos, state);
    }

    private int getPower(IBlockAccess world, BlockPos pos) {
        DHDAbstractTile tile = (DHDAbstractTile)world.func_175625_s(pos);
        if (!tile.isLinked()) {
            return 0;
        }
        StargateClassicBaseTile gateTile = (StargateClassicBaseTile)tile.getLinkedGate(world);
        if (gateTile == null) {
            return 0;
        }
        if (gateTile.getStargateState().engaged() || gateTile.getStargateState().unstable()) {
            return 15;
        }
        return gateTile.getDialedAddress().size() > 0 ? gateTile.getDialedAddress().size() + 3 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(world, pos);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public boolean renderHighlight(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int rotation = (int)((float)((Integer)state.func_177229_b((IProperty)JSGProps.ROTATION_HORIZONTAL)).intValue() * 22.5f);
        if (rotation % 90 == 0) {
            return new JSGAxisAlignedBB(-0.5, 0.0, -0.25, 0.5, 1.0, 0.25).rotate(rotation).offset(0.5, 0.0, 0.5);
        }
        return new JSGAxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int rotation = (int)((float)((Integer)state.func_177229_b((IProperty)JSGProps.ROTATION_HORIZONTAL)).intValue() * 22.5f);
        if (rotation % 90 == 0) {
            return new JSGAxisAlignedBB(-0.5, 0.0, -0.25, 0.5, 1.3, 0.25).rotate(rotation).offset(0.5, 0.0, 0.5);
        }
        return new JSGAxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.3, 0.75);
    }
}

